/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.shell.spring;

import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.support.DefaultBannerProvider;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.stereotype.Component;

/**
 * MapR-DB shell banner displayed at startup
 */
@Component
@Order(Ordered.HIGHEST_PRECEDENCE)
public class BannerProvider extends DefaultBannerProvider  {
  private static final String VERSION;
  static {
    String version = BannerProvider.class.getPackage().getImplementationVersion();
    VERSION = version == null ? "<unknown>" : version;
  }

  public String getBanner() {
    StringBuffer buf = new StringBuffer();
    buf.append("====================================================" + OsUtils.LINE_SEPARATOR);
    buf.append("*                  MapR-DB Shell                   *" + OsUtils.LINE_SEPARATOR);
    buf.append("* NOTE: This is a shell for JSON table operations. *" + OsUtils.LINE_SEPARATOR);
    buf.append("====================================================" + OsUtils.LINE_SEPARATOR);
    buf.append("Version: " + this.getVersion() + OsUtils.LINE_SEPARATOR);
    return buf.toString();
  }

  public String getVersion() {
    return VERSION;
  }

  public String getWelcomeMessage() {
    return "MapR-DB Shell";
  }

  @Override
  public String getProviderName() {
    return "MapR Technologies, Inc.";
  }

}
