package com.mapr.db.shell.commands;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import org.ojai.json.JsonOptions;
import org.springframework.shell.core.ExecutionProcessor;
import org.springframework.shell.event.ParseResult;
import org.springframework.stereotype.Component;

import com.mapr.db.shell.ShellSession;

@Component
public abstract class ShellCommands implements ExecutionProcessor {

  protected ShellSession session_;

  protected ShellCommands() throws IOException {
    session_ = ShellSession.getSession();
  }

  protected JsonOptions getCmdJsonOptions(String withTags, String pretty) {
    JsonOptions jsonOptions = session_.getJsonOptions();
    if (withTags != null || pretty != null) {
      jsonOptions = jsonOptions.clone();
      if (withTags != null) {
        jsonOptions.setWithTags(Boolean.valueOf(withTags));
      }
      if (pretty != null) {
        jsonOptions.setPretty(Boolean.valueOf(pretty));
      }
    }
    return jsonOptions;
  }

  /**
   * Method called before invoking the target command (described by {@link ParseResult}).
   * Additionally, for advanced cases, the parse result itself effectively changing the invocation
   * calling site.
   *
   * @param invocationContext target command context
   * @return the invocation target
   */
  @Override
  public ParseResult beforeInvocation(ParseResult invocationContext) {
    return invocationContext;
  }

  /**
   * Method called after successfully invoking the target command (described by {@link ParseResult}).
   *
   * @param invocationContext target command context
   * @param result the invocation result
   */
  @Override
  public void afterReturningInvocation(ParseResult invocationContext, Object result) {
  }

  /**
   * Method called after invoking the target command (described by {@link ParseResult}) had thrown an exception .
   *
   * @param invocationContext target command context
   * @param thrown the thrown object
   */
  @Override
  public void afterThrowingInvocation(ParseResult invocationContext, Throwable thrown) {
    if ((thrown instanceof IllegalStateException
          || thrown instanceof InvocationTargetException)
        && thrown.getCause() != null) {
      thrown = thrown.getCause();
    }
    if (session_.isDebug()) {
      thrown.printStackTrace(System.err);
    } else {
      System.err.println(thrown.getMessage());
    }
  }

}
