/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.shell;

import static com.mapr.db.Table.TableOption.BUFFERWRITE;
import static com.mapr.db.Table.TableOption.EXCLUDEID;
import static com.mapr.db.Table.TableOption.KEEPINSERTIONORDER;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

import com.mapr.db.Table.TableOption;

public class TableOptions extends HashMap<TableOption, Boolean> {
  private static final long serialVersionUID = 1L;

  TableOptions() {
    put(EXCLUDEID, false);
    put(BUFFERWRITE, false);
    put(KEEPINSERTIONORDER, true);
  }

  public boolean isExcludeId() {
    return get(EXCLUDEID);
  }

  public boolean isBufferWrite() {
    return get(BUFFERWRITE);
  }

  public boolean isKeepInsertionOrder() {
    return get(KEEPINSERTIONORDER);
  }

  public boolean setExcludeId(boolean value) {
    return put(EXCLUDEID, value);
  }

  public boolean setBufferWrite(boolean value) {
    return put(BUFFERWRITE, value);
  }

  public boolean setKeepInsertionOrder(boolean value) {
    return put(KEEPINSERTIONORDER, value);
  }

  @Override
  public String toString() {
    Iterator<Entry<TableOption, Boolean>> i = entrySet().iterator();
    if (!i.hasNext())
      return "{}";

    StringBuilder sb = new StringBuilder();
    sb.append('{');
    for (;;) {
      Entry<TableOption, Boolean> e = i.next();
      TableOption key = e.getKey();
      Boolean value = e.getValue();
      sb.append('"');
      switch (key) {
      case BUFFERWRITE:
        sb.append("bufferwrite"); break;
      case EXCLUDEID:
        sb.append("excludeid"); break;
      case KEEPINSERTIONORDER:
        sb.append("insertionorder"); break;
      }
      sb.append("\":");
      sb.append(value);
      if (!i.hasNext())
        return sb.append('}').toString();
      sb.append(',').append(' ');
    }
  }

}
