/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.shell;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.springframework.shell.Bootstrap;
import org.springframework.shell.core.SimpleExecutionStrategy;

/**
 * Driver class to run the MapR-DB Json Shell.
 */
public class MapRDBShell {
  /**
   * Main class that delegates to Spring Shell's Bootstrap class in order to
   * simplify debugging inside an IDE
   * @param args
   * @throws IOException 
   */
  public static void main(String[] args) throws IOException {
    // turn off the SimpleExecutionStrategy logger to avoid printing
    // exception messages on console.
    Logger execution_logger = Logger.getLogger(SimpleExecutionStrategy.class.getName());
    execution_logger.setLevel(Level.OFF);
    Bootstrap.main(args);
  }

}
