/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.commands;

import com.mapr.db.shell.commands.ShellCommands;
import java.io.IOException;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class SessionCommnds
extends ShellCommands {
    protected SessionCommnds() throws IOException {
    }

    @CliAvailabilityIndicator(value={"debug"})
    public boolean available() {
        return true;
    }

    @CliAvailabilityIndicator(value={"mode"})
    public boolean modeAvailable() {
        return false;
    }

    @CliCommand(value={"debug"}, help="Sets/shows the debug mode.")
    public String debug(@CliOption(key={""}, help="Set the debug mode to on/off") String mode, @CliOption(key={"rawstream"}, specifiedDefaultValue="true", hidden=true) Boolean rawStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (mode != null) {
            this.session_.setDebug("on".equalsIgnoreCase(mode));
        }
        sb.append("Debug Mode: ").append(this.session_.isDebug() ? "On" : "Off");
        if (rawStream != null) {
            this.session_.setRawStreamScan(rawStream);
            sb.append("\nStream Scan Mode: ").append(this.session_.isRawStreamScan() ? "Raw" : "Messages");
        }
        return sb.toString();
    }

    public String mode(@CliOption(key={""}, help="Sets/shows the active mode (global|files|tables|stream) of the session.") String mode) throws IOException {
        if (mode != null) {
            this.session_.setMode(mode);
        }
        return "Session mode is set to " + (Object)((Object)this.session_.getMode()) + ".";
    }

    @CliCommand(value={"jsonoptions"}, help="Sets/shows the Json output options.")
    public String jsonoption(@CliOption(key={"pretty"}, help="Sets/clears the pretty printing mode.", specifiedDefaultValue="true") Boolean pretty, @CliOption(key={"withtags", "withTags"}, help="Enables/disables printing with extended Type Tags.", specifiedDefaultValue="true") Boolean withTags) throws IOException {
        if (pretty != null) {
            this.session_.getJsonOptions().setPretty(pretty.booleanValue());
        }
        if (withTags != null) {
            this.session_.getJsonOptions().setWithTags(withTags.booleanValue());
        }
        return String.valueOf(this.session_.getJsonOptions());
    }

    @CliCommand(value={"tableoptions"}, help="Sets/shows the MapR-DB Table access options.")
    public String tableoption(@CliOption(key={"bufferwrite", "bufferWrite"}, help="Sets/clears the buffered write mode when inserting documents.", specifiedDefaultValue="false") Boolean bufferwrite, @CliOption(key={"excludeid", "excludeId"}, help="Enables/disables exclusion of '_id' field when printing documents.", specifiedDefaultValue="false") Boolean excludeId, @CliOption(key={"insertionorder", "insertionOrder"}, help="Enables/disables insertion order when printing documents.", specifiedDefaultValue="true") Boolean insertionOrder) throws IOException {
        if (bufferwrite != null) {
            this.session_.getTableOptions().setBufferWrite(bufferwrite);
        }
        if (excludeId != null) {
            this.session_.getTableOptions().setExcludeId(excludeId);
        }
        if (insertionOrder != null) {
            this.session_.getTableOptions().setKeepInsertionOrder(insertionOrder);
        }
        return String.valueOf(this.session_.getTableOptions());
    }
}

