/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.commands;

import com.mapr.db.shell.ShellSession;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.ojai.json.JsonOptions;
import org.springframework.shell.core.ExecutionProcessor;
import org.springframework.shell.event.ParseResult;
import org.springframework.stereotype.Component;

@Component
public abstract class ShellCommands
implements ExecutionProcessor {
    protected ShellSession session_ = ShellSession.getSession();

    protected ShellCommands() throws IOException {
    }

    protected JsonOptions getCmdJsonOptions(String withTags, String pretty) {
        JsonOptions jsonOptions = this.session_.getJsonOptions();
        if (withTags != null || pretty != null) {
            jsonOptions = jsonOptions.clone();
            if (withTags != null) {
                jsonOptions.setWithTags(Boolean.valueOf(withTags).booleanValue());
            }
            if (pretty != null) {
                jsonOptions.setPretty(Boolean.valueOf(pretty).booleanValue());
            }
        }
        return jsonOptions;
    }

    public ParseResult beforeInvocation(ParseResult invocationContext) {
        return invocationContext;
    }

    public void afterReturningInvocation(ParseResult invocationContext, Object result) {
    }

    public void afterThrowingInvocation(ParseResult invocationContext, Throwable thrown) {
        if ((thrown instanceof IllegalStateException || thrown instanceof InvocationTargetException) && thrown.getCause() != null) {
            thrown = thrown.getCause();
        }
        if (this.session_.isDebug()) {
            thrown.printStackTrace(System.err);
        } else {
            System.err.println(thrown.getMessage());
        }
    }
}

