/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.commands;

import com.mapr.db.shell.commands.ShellCommands;
import com.mapr.db.shell.ops.FileOps;
import java.io.IOException;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class FileCommands
extends ShellCommands {
    private FileOps fileOps_;

    public FileCommands() throws IOException {
        this.fileOps_ = new FileOps(this.session_);
    }

    @CliAvailabilityIndicator(value={"ls", "pwd", "cd", "cat"})
    public boolean available() {
        return true;
    }

    @CliCommand(value={"ls"}, help="Lists files and folders.")
    public String ls(@CliOption(key={"", "path", "p"}, help="Path") String path) throws Exception {
        this.fileOps_.listFiles(path);
        return null;
    }

    @CliCommand(value={"pwd"}, help="Print the absolute path of the current working directory.")
    public String pwd() throws IOException {
        this.fileOps_.pwd();
        return null;
    }

    @CliCommand(value={"cd"}, help="Change the current directory to the specified path.")
    public String cd(@CliOption(key={"", "path", "p"}, specifiedDefaultValue="User's home directory") String path) throws IOException {
        this.fileOps_.setWorkingDirectory(path);
        return null;
    }

    @CliCommand(value={"mkdir"}, help="Create a directory at the specified path.")
    public String mkdir(@CliOption(key={"", "path", "p"}) String path) throws IOException {
        this.fileOps_.mkdir(path);
        return null;
    }

    @CliCommand(value={"cat"}, help="Print the content of the specified file on the standard output")
    public String cat(@CliOption(key={"", "path", "p"}, mandatory=true, specifiedDefaultValue="File to print") String path) throws IOException {
        this.fileOps_.cat(path);
        return null;
    }
}

