/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell;

import com.mapr.db.shell.SessionMode;
import com.mapr.db.shell.TableOptions;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.ojai.json.JsonOptions;
import org.springframework.shell.ShellException;

public class ShellSession {
    private final MapRFileSystem fs_;
    private final Path homeDir;
    private final JsonOptions jsonOptions_;
    private final TableOptions tableOptions_;
    private SessionMode mode_ = SessionMode.TABLES;
    private boolean isDebug = false;
    private static volatile ShellSession INSTACE;

    private ShellSession() throws IOException {
        try {
            this.fs_ = new MapRFileSystem();
            this.fs_.initialize(new URI("maprfs:///"), new Configuration());
            this.homeDir = this.fs_.getHomeDirectory();
            this.jsonOptions_ = new JsonOptions().withTags();
            this.tableOptions_ = new TableOptions();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getHomeDir() {
        return this.homeDir;
    }

    public MapRFileSystem getFS() {
        return this.fs_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShellSession getSession() {
        if (INSTACE != null) return INSTACE;
        Class<ShellSession> clazz = ShellSession.class;
        synchronized (ShellSession.class) {
            if (INSTACE != null) return INSTACE;
            try {
                INSTACE = new ShellSession();
            }
            catch (IOException e) {
                throw new ShellException((Throwable)e);
            }
            return INSTACE;
        }
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void setMode(String mode) {
        this.mode_ = SessionMode.valueOf(mode.toUpperCase());
    }

    public void setMode(SessionMode mode) {
        this.mode_ = mode;
    }

    public SessionMode getMode() {
        return this.mode_;
    }

    public boolean inGlobalMode() {
        return this.mode_ == SessionMode.GLOBAL;
    }

    public boolean inTableMode() {
        return this.mode_ == SessionMode.TABLES;
    }

    public Path getCWD() {
        return this.fs_.getWorkingDirectory();
    }

    public JsonOptions getJsonOptions() {
        return this.jsonOptions_;
    }

    public TableOptions getTableOptions() {
        return this.tableOptions_;
    }
}

