/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.ops;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.shell.ShellSession;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;

public class TableOps {
    private static final String DOC_ID_NOT_FOUND = "A document id was neither provided nor found in the document.";
    private final AdminImpl admin;
    private final MapRFileSystem fs_;
    private final ShellSession session_;
    private final LoadingCache<Path, Table> tableCache;

    public TableOps(ShellSession session_) throws IOException {
        this.fs_ = session_.getFS();
        this.admin = new AdminImpl(this.fs_);
        this.session_ = session_;
        this.tableCache = CacheBuilder.newBuilder().maximumSize(50L).removalListener((RemovalListener)new RemovalListener<Path, Table>(){

            public void onRemoval(RemovalNotification<Path, Table> notification) {
                try {
                    ((Table)notification.getValue()).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).build((CacheLoader)new CacheLoader<Path, Table>(){

            public Table load(Path tablePath) throws Exception {
                return MapRDB.getTable((Path)tablePath);
            }
        });
    }

    public void create(String tablePath) throws IOException {
        this.putTable(tablePath, this.admin.createTable(tablePath));
        System.out.printf("Table %s created.\n", tablePath);
    }

    public void deleteTable(String tablePath) throws IOException {
        if (!this.admin.deleteTable(tablePath)) {
            System.out.printf("Unable to delete table: '%s'. Check if the path exists and is a table.\n", tablePath);
        } else {
            this.removeTable(tablePath);
            System.out.printf("Table %s deleted.\n", tablePath);
        }
    }

    public void findById(String tablePath, String id) throws IOException {
        Document readDocument = this.getTable(tablePath).findById(id);
        String json = readDocument.asJsonString(ShellSession.getSession().getJsonOptions());
        System.out.println(json);
    }

    public void find(String tablePath, String fromId, String toId, String limitStr) throws IOException {
        QueryCondition c = null;
        if (fromId != null || toId != null) {
            c = MapRDB.newCondition();
            if (fromId != null && toId != null) {
                c.and();
            }
            if (fromId != null) {
                c.is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, fromId);
            }
            if (toId != null) {
                c.is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, toId);
            }
            if (fromId != null && toId != null) {
                c.close();
            }
            c.build();
        }
        long count = 0L;
        long limit = Long.MAX_VALUE;
        if (limitStr != null) {
            limit = Long.parseLong(limitStr);
        }
        for (Document document : this.getTable(tablePath).find(c)) {
            String json = document.asJsonString(ShellSession.getSession().getJsonOptions());
            System.out.printf("%s\n", json);
            if (++count != limit) continue;
            break;
        }
        System.out.printf("%d document(s) found.\n", count);
    }

    public void insert(String tablePath, String docId, String jsonStr) throws IOException {
        Document document = MapRDB.newDocument((String)jsonStr);
        String inDocId = null;
        boolean inDoc = false;
        if (docId == null) {
            inDocId = document.getString(DocumentConstants.ID_FIELD);
            inDoc = true;
        } else {
            inDocId = document.getString(DocumentConstants.ID_FIELD);
            if (inDocId != null && !inDocId.equals(docId)) {
                throw new UnsupportedOperationException("ERROR: '_id' field in the json string '" + inDocId + "' should " + " match input parameter '" + docId + "' or only one of them can be provided.");
            }
            inDocId = docId;
        }
        if (inDocId == null) {
            throw new UnsupportedOperationException("ERROR: Expected an '_id' field either in the json string or as an input '--id' parameter.");
        }
        if (inDoc) {
            document.delete(DocumentConstants.ID_FIELD);
            document.setId(inDocId);
            Table t = this.getTable(tablePath);
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            t.insertOrReplace(document);
        } else {
            Table t = this.getTable(tablePath);
            t.setOption(Table.TableOption.BUFFERWRITE, false);
            t.insertOrReplace(inDocId, document);
        }
        System.out.printf("Document with id: \"%s\" inserted.\n", inDocId);
    }

    public void deleteRow(String tablePath, String docId) throws IOException {
        Table t = this.getTable(tablePath);
        t.setOption(Table.TableOption.BUFFERWRITE, false);
        t.delete(docId);
        System.out.printf("Document with id: \"%s\" deleted.\n", docId);
    }

    public void update(String tablePath, String docId, String keyValues) throws IOException {
        Document document = MapRDB.newDocument((String)keyValues);
        if (docId == null) {
            docId = document.getIdString();
            Preconditions.checkArgument((docId != null ? 1 : 0) != 0, (Object)DOC_ID_NOT_FOUND);
            document.delete(DocumentConstants.ID_FIELD);
        }
        DocumentMutation mutation = MapRDB.newMutation();
        for (Map.Entry entry : document) {
            Value v = (Value)entry.getValue();
            if (v.getType() == Value.Type.MAP || v.getType() == Value.Type.ARRAY) {
                throw new UnsupportedOperationException("ERROR: update of " + v.getType() + " type is not supported yet.");
            }
            mutation.setOrReplace((String)entry.getKey(), v);
        }
        this.getTable(tablePath).update(docId, mutation);
        System.out.printf("Document with id: \"%s\" updated.\n", docId);
    }

    public void exists(String tablePath) throws IOException {
        System.out.println(this.admin.tableExists(tablePath));
    }

    public void list(String parent) throws IOException {
        List tables = this.admin.listTables(parent);
        if (tables == null) {
            System.out.printf("No tables found.\n", new Object[0]);
            return;
        }
        for (Path path : tables) {
            System.out.println(path);
        }
        System.out.printf("%d table(s) found.\n", tables.size());
    }

    public void desc(String tablePath) throws IOException {
        System.out.println(this.admin.getTableDescriptor(tablePath));
    }

    private void removeTable(String tablePath) throws IOException {
        this.tableCache.invalidate((Object)this.fs_.makeAbsolute(new Path(tablePath)));
    }

    private void putTable(String tablePath, Table table) throws IOException {
        this.tableCache.put((Object)this.fs_.makeAbsolute(new Path(tablePath)), (Object)table);
    }

    private Table getTable(String tablePath) throws IOException {
        try {
            return ((Table)this.tableCache.get((Object)this.fs_.makeAbsolute(new Path(tablePath)))).setOption(Table.TableOption.EXCLUDEID, this.session_.getTableOptions().isExcludeId()).setOption(Table.TableOption.BUFFERWRITE, this.session_.getTableOptions().isBufferWrite()).setOption(Table.TableOption.KEEPINSERTIONORDER, this.session_.getTableOptions().isKeepInsertionOrder());
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DBException) {
                throw (DBException)cause;
            }
            throw ExceptionHandler.handle((IOException)(cause instanceof IOException ? (IOException)cause : new IOException(cause)), (String)"getTable()");
        }
    }
}

