/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.ops;

import com.mapr.db.shell.ShellSession;
import com.mapr.fs.MapRFileStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import jline.internal.InputStreamReader;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class FileOps {
    private final ShellSession session_;
    private String oldpwd = null;

    public FileOps(ShellSession session) throws IOException {
        this.session_ = session;
    }

    public String getWorkingDirectory() {
        return this.session_.getCWD().toUri().getPath();
    }

    public void setWorkingDirectory(String pathStr) throws IOException {
        Path path = null;
        if (pathStr != null) {
            if ("-".equals(pathStr)) {
                if (this.oldpwd != null) {
                    pathStr = this.oldpwd;
                } else {
                    throw new IllegalStateException("OLDPWD not set");
                }
            }
            path = new Path(pathStr);
            MapRFileStatus stat = this.session_.getFS().getMapRFileStatus(path);
            if (!stat.isDirectory()) {
                throw new IllegalArgumentException(pathStr + " is not a directory");
            }
        }
        this.oldpwd = this.session_.getCWD().toUri().getPath();
        this.session_.getFS().setWorkingDirectory(path == null ? this.session_.getHomeDir() : path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listFiles(String pathStr) throws Exception {
        try (FsShell cli = new FsShell(this.session_.getFS().getConf());){
            if (pathStr == null) {
                pathStr = this.getWorkingDirectory();
            }
            ToolRunner.run((Tool)cli, (String[])new String[]{"-ls", pathStr});
        }
    }

    public void pwd() {
        System.out.println(this.getWorkingDirectory());
    }

    public void cat(String pathStr) throws IllegalArgumentException, IOException {
        Path path = new Path(pathStr);
        MapRFileStatus stat = this.session_.getFS().getMapRFileStatus(path);
        if (!stat.isRegular()) {
            throw new IllegalArgumentException(pathStr + " is not a regular file");
        }
        try (FSDataInputStream in = this.session_.getFS().open(path);
             BufferedReader reader = new BufferedReader((Reader)new InputStreamReader((InputStream)in, "UTF-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
    }
}

