/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.rowcol.SequenceFileRowColCodec;
import com.mapr.db.util.ByteBufs;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.ojai.Document;

public class DBDocumentSerialization
extends Configured
implements Serialization<Document> {
    public boolean accept(Class<?> arg0) {
        return Document.class.isAssignableFrom(arg0);
    }

    public Deserializer<Document> getDeserializer(Class<Document> arg0) {
        return new DocumentDeserializer();
    }

    public Serializer<Document> getSerializer(Class<Document> arg0) {
        return new DocumentSerializer();
    }

    private static class DocumentSerializer
    implements Serializer<Document> {
        OutputStream out;

        private DocumentSerializer() {
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void open(OutputStream out) throws IOException {
            this.out = out;
        }

        public void serialize(Document record) throws IOException {
            int remaining;
            ByteBuffer outBuffer = SequenceFileRowColCodec.encode((Document)record);
            this.out.write(Bytes.toBytes((int)outBuffer.remaining()));
            int maxRead = 128;
            byte[] buffer = new byte[128];
            while ((remaining = Math.min(outBuffer.remaining(), 128)) > 0) {
                outBuffer.get(buffer, 0, remaining);
                this.out.write(buffer, 0, remaining);
            }
        }
    }

    private static class DocumentDeserializer
    implements Deserializer<Document> {
        DataInputStream d;

        private DocumentDeserializer() {
        }

        public void close() throws IOException {
            this.d.close();
        }

        public Document deserialize(Document record) throws IOException {
            int lenSize = 4;
            byte[] recSize = new byte[4];
            this.d.read(recSize, 0, 4);
            int recordSize = Bytes.toInt((byte[])recSize);
            if (recordSize < 0) {
                throw new IllegalArgumentException("Invalid record size " + recordSize);
            }
            byte[] b = new byte[recordSize];
            this.d.read(b, 0, recordSize);
            ByteBuffer buffer = ByteBufs.wrap((byte[])b);
            return SequenceFileRowColCodec.decode((ByteBuffer)buffer);
        }

        public void open(InputStream in) throws IOException {
            this.d = new DataInputStream(in);
        }
    }
}

