/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.impl;

import com.google.common.io.BaseEncoding;
import com.mapr.db.Admin;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.util.ByteBufs;
import com.mapr.fs.proto.Marlinserver;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.Value;
import org.ojai.store.QueryCondition;

public class MapReduceUtilMethods {
    public static void setStartStopRow(Configuration conf) {
        String startRow = conf.get("maprdb.mapreduce.getall.startrow");
        String endRow = conf.get("maprdb.mapreduce.getall.stoprow");
        if (startRow == null && endRow == null) {
            return;
        }
        ConditionImpl cond = MapRDBImpl.newCondition();
        if (startRow != null && endRow != null) {
            cond.and();
        }
        if (startRow != null) {
            cond.is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, startRow);
        }
        if (endRow != null) {
            cond.is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS_OR_EQUAL, endRow);
        }
        if (startRow != null && endRow != null) {
            cond.close();
        }
        cond.build();
        ByteBuffer serializedCond = cond.getDescriptor().getSerialized();
        byte[] condArray = new byte[serializedCond.remaining()];
        serializedCond.get(condArray);
        String conditionString = BaseEncoding.base64().encode(condArray);
        conf.set("maprdb.mapreduce.condition", conditionString);
    }

    public static String[] getStreamDefaultCFsForRepl() {
        Marlinserver.MarlinInternalDefaults def = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
        String[] fields = new String[]{def.getCfTopicMeta(), def.getCfMessages().equals("default") ? new String("") : def.getCfMessages(), def.getCfCursors()};
        return fields;
    }

    public static String processColumnSpec(String columnSpec, String tabPath) {
        String[] fields = null;
        Admin admin = MapRDBImpl.newAdmin();
        TableDescriptorImpl desc = (TableDescriptorImpl)admin.getTableDescriptor(tabPath);
        if (columnSpec != null) {
            fields = columnSpec.split(",", -1);
        } else if (desc.isStream()) {
            fields = MapReduceUtilMethods.getStreamDefaultCFsForRepl();
        }
        if (fields != null) {
            int numFields = fields.length;
            StringBuilder cols = new StringBuilder();
            for (int i = 0; i < numFields; ++i) {
                cols.append(fields[i]);
                if (i >= numFields - 1) continue;
                cols.append(",");
            }
            return cols.toString();
        }
        return null;
    }

    public static ByteBuffer getRowKey(Document record, String field) {
        Value value = record.getValue(field);
        if (value.getType() == Value.Type.BINARY) {
            return value.getBinary();
        }
        if (value.getType() == Value.Type.STRING) {
            try {
                return ByteBufs.wrap((byte[])value.getString().getBytes("UTF-8"));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String[] getFieldPaths(String fieldPaths) {
        String[] tokens = fieldPaths.split(",", -1);
        ArrayList<Object> pathList = new ArrayList<Object>();
        int length = tokens.length;
        Object currentToken = null;
        for (int count = 0; count < length; ++count) {
            if (currentToken != null) {
                currentToken = currentToken + "," + tokens[count];
                if (!tokens[count].endsWith(String.valueOf('\"'))) continue;
                pathList.add(currentToken);
                currentToken = null;
                continue;
            }
            if (tokens[count].charAt(0) != '\"') {
                pathList.add(tokens[count]);
                continue;
            }
            currentToken = tokens[count];
        }
        String[] paths = new String[pathList.size()];
        paths = pathList.toArray(paths);
        return paths;
    }

    public static boolean checkBulkloadStatus(boolean blkOption, String dstPath) {
        TableDescriptorImpl descriptor;
        Admin maprAdmin = MapRDBImpl.newAdmin();
        return !maprAdmin.tableExists(dstPath) || !(descriptor = (TableDescriptorImpl)maprAdmin.getTableDescriptor(dstPath)).isBulkLoad() || blkOption;
    }
}

