/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.impl.IdCodec;
import com.mapr.db.util.ByteBufs;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.ojai.Document;
import org.ojai.Value;

public class ValueSerialization
extends Configured
implements Serialization<Value> {
    public boolean accept(Class<?> c) {
        return Value.class.isAssignableFrom(c) && !Document.class.isAssignableFrom(c);
    }

    public Serializer<Value> getSerializer(Class<Value> c) {
        return new ValueSerializer();
    }

    public Deserializer<Value> getDeserializer(Class<Value> c) {
        return new ValueDeserializer();
    }

    private static class ValueSerializer
    implements Serializer<Value> {
        OutputStream out;

        private ValueSerializer() {
        }

        public void open(OutputStream out) throws IOException {
            this.out = out;
        }

        public void serialize(Value t) throws IOException {
            int remaining;
            ByteBuffer b = IdCodec.encode((Value)t);
            this.out.write(Bytes.toBytes((int)b.remaining()));
            int maxRead = 128;
            byte[] buffer = new byte[128];
            while ((remaining = Math.min(b.remaining(), 128)) > 0) {
                b.get(buffer, 0, remaining);
                this.out.write(buffer, 0, remaining);
            }
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    private static class ValueDeserializer
    implements Deserializer<Value> {
        DataInputStream d;

        private ValueDeserializer() {
        }

        public void open(InputStream in) throws IOException {
            this.d = new DataInputStream(in);
        }

        public Value deserialize(Value t) throws IOException {
            int lenSize = 4;
            byte[] recSize = new byte[4];
            this.d.read(recSize, 0, 4);
            int recordSize = Bytes.toInt((byte[])recSize);
            if (recordSize < 0) {
                throw new IllegalArgumentException("Invalid record size " + recordSize);
            }
            byte[] b = new byte[recordSize];
            this.d.read(b, 0, recordSize);
            ByteBuffer buffer = ByteBufs.wrap((byte[])b);
            return IdCodec.decode((ByteBuffer)buffer);
        }

        public void close() throws IOException {
            this.d.close();
        }
    }
}

