/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.impl;

import com.mapr.db.util.ByteBufs;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.WritableComparable;

public class ByteBufWritableComparable
implements WritableComparable<ByteBufWritableComparable> {
    public static ByteBufWritableComparable EMPTY_BYTEBUFFER = new ByteBufWritableComparable(ByteBuffer.wrap(new byte[0]));
    private ByteBuffer key;

    public ByteBufWritableComparable() {
    }

    public ByteBufWritableComparable(ByteBuffer buff) {
        this.key = buff;
    }

    public int getLength() {
        return this.key.limit();
    }

    public byte[] getBytes() {
        if (!this.key.hasArray()) {
            return null;
        }
        return this.key.array();
    }

    public ByteBuffer getByteBuf() {
        return this.key;
    }

    public void setByteBuf(ByteBuffer b) {
        this.key = b.slice();
    }

    public void readFields(DataInput in) throws IOException {
        int length = in.readInt();
        this.key = ByteBufs.allocatePreferred((int)length);
        in.readFully(this.key.array());
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.key.remaining());
        if (this.key.hasArray()) {
            out.write(this.key.array(), this.key.position(), this.key.limit());
        } else {
            byte[] data = new byte[this.key.remaining()];
            this.key.duplicate().get(data);
            out.write(data, 0, data.length);
        }
    }

    public boolean equals(Object b) {
        if (b instanceof ByteBufWritableComparable) {
            return this.key.equals(((ByteBufWritableComparable)b).getByteBuf());
        }
        return false;
    }

    public int compareTo(ByteBufWritableComparable o) {
        return this.key.compareTo(o.getByteBuf());
    }

    public String toString() {
        if (this.key == null) {
            return null;
        }
        ByteBuffer dup = this.key.duplicate();
        return Bytes.toStringBinary((ByteBuffer)dup);
    }
}

