/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TotalOrderPartitioner<K, V>
extends Partitioner<K, V>
implements Configurable {
    private Node partitions;
    public static final String DEFAULT_PATH = "_partition.lst";
    public static final String PARTITIONER_PATH = "mapreduce.totalorderpartitioner.path";
    public static final String MAX_TRIE_DEPTH = "mapreduce.totalorderpartitioner.trie.maxdepth";
    public static final String NATURAL_ORDER = "mapreduce.totalorderpartitioner.naturalorder";
    Configuration conf;
    private static final Log LOG = LogFactory.getLog(TotalOrderPartitioner.class);

    public void setConf(Configuration conf) {
        try {
            this.conf = conf;
            String parts = TotalOrderPartitioner.getPartitionFile(conf);
            Path partFile = new Path(parts);
            LocalFileSystem fs = DEFAULT_PATH.equals(parts) ? FileSystem.getLocal((Configuration)conf) : partFile.getFileSystem(conf);
            Job job = new Job(conf);
            Class keyClass = job.getMapOutputKeyClass();
            K[] splitPoints = this.readPartitions((FileSystem)fs, partFile, keyClass, conf);
            if (splitPoints.length != job.getNumReduceTasks() - 1) {
                throw new IOException("Wrong number of partitions in keyset");
            }
            RawComparator comparator = job.getSortComparator();
            for (int i = 0; i < splitPoints.length - 1; ++i) {
                if (comparator.compare(splitPoints[i], splitPoints[i + 1]) < 0) continue;
                throw new IOException("Split points are out of order");
            }
            boolean natOrder = conf.getBoolean(NATURAL_ORDER, true);
            this.partitions = natOrder && BinaryComparable.class.isAssignableFrom(keyClass) ? this.buildTrie((BinaryComparable[])splitPoints, 0, splitPoints.length, new byte[0], conf.getInt(MAX_TRIE_DEPTH, 200)) : new BinarySearchNode(splitPoints, comparator);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read partitions file", e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int getPartition(K key, V value, int numPartitions) {
        return this.partitions.findPartition(key);
    }

    public static void setPartitionFile(Configuration conf, Path p) {
        conf.set(PARTITIONER_PATH, p.toString());
    }

    public static String getPartitionFile(Configuration conf) {
        return conf.get(PARTITIONER_PATH, DEFAULT_PATH);
    }

    private TrieNode LeafTrieNodeFactory(int level, BinaryComparable[] splitPoints, int lower, int upper) {
        switch (upper - lower) {
            case 0: {
                return new UnsplitTrieNode(level, lower);
            }
            case 1: {
                return new SinglySplitTrieNode(level, splitPoints, lower);
            }
        }
        return new LeafTrieNode(level, splitPoints, lower, upper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private K[] readPartitions(FileSystem fs, Path p, Class<K> keyClass, Configuration conf) throws IOException {
        SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)p)});
        ArrayList<Object> parts = new ArrayList<Object>();
        Object key = ReflectionUtils.newInstance(keyClass, (Configuration)conf);
        try {
            while ((key = reader.next(key)) != null) {
                parts.add(key);
                key = ReflectionUtils.newInstance(keyClass, (Configuration)conf);
            }
            reader.close();
            reader = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{reader});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{reader});
        return parts.toArray((Object[])Array.newInstance(keyClass, parts.size()));
    }

    private TrieNode buildTrie(BinaryComparable[] splits, int lower, int upper, byte[] prefix, int maxDepth) {
        return this.buildTrieRec(splits, lower, upper, prefix, maxDepth, new CarriedTrieNodeRef());
    }

    private TrieNode buildTrieRec(BinaryComparable[] splits, int lower, int upper, byte[] prefix, int maxDepth, CarriedTrieNodeRef ref) {
        int depth = prefix.length;
        if (depth >= maxDepth || lower >= upper - 1) {
            if (lower == upper && ref.content != null) {
                return ref.content;
            }
            TrieNode result = this.LeafTrieNodeFactory(depth, splits, lower, upper);
            ref.content = lower == upper ? result : null;
            return result;
        }
        InnerTrieNode result = new InnerTrieNode(depth);
        byte[] trial = Arrays.copyOf(prefix, prefix.length + 1);
        int currentBound = lower;
        for (int ch = 0; ch < 255; ++ch) {
            trial[depth] = (byte)(ch + 1);
            lower = currentBound;
            while (currentBound < upper && splits[currentBound].compareTo(trial, 0, trial.length) < 0) {
                ++currentBound;
            }
            trial[depth] = (byte)ch;
            result.child[0xFF & ch] = this.buildTrieRec(splits, lower, currentBound, trial, maxDepth, ref);
        }
        trial[depth] = -1;
        result.child[255] = this.buildTrieRec(splits, lower, currentBound, trial, maxDepth, ref);
        return result;
    }

    private class CarriedTrieNodeRef {
        TrieNode content = null;

        CarriedTrieNodeRef() {
        }
    }

    private class SinglySplitTrieNode
    extends TrieNode {
        final int lower;
        final BinaryComparable mySplitPoint;

        SinglySplitTrieNode(int level, BinaryComparable[] splitPoints, int lower) {
            super(level);
            this.lower = lower;
            this.mySplitPoint = splitPoints[lower];
        }

        @Override
        public int findPartition(BinaryComparable key) {
            return this.lower + (key.compareTo(this.mySplitPoint) < 0 ? 0 : 1);
        }
    }

    private class UnsplitTrieNode
    extends TrieNode {
        final int result;

        UnsplitTrieNode(int level, int value) {
            super(level);
            this.result = value;
        }

        @Override
        public int findPartition(BinaryComparable key) {
            return this.result;
        }
    }

    private class LeafTrieNode
    extends TrieNode {
        final int lower;
        final int upper;
        final BinaryComparable[] splitPoints;

        LeafTrieNode(int level, BinaryComparable[] splitPoints, int lower, int upper) {
            super(level);
            this.lower = lower;
            this.upper = upper;
            this.splitPoints = splitPoints;
        }

        @Override
        public int findPartition(BinaryComparable key) {
            int pos = Arrays.binarySearch(this.splitPoints, this.lower, this.upper, key) + 1;
            return pos < 0 ? -pos : pos;
        }
    }

    class InnerTrieNode
    extends TrieNode {
        private TrieNode[] child;

        InnerTrieNode(int level) {
            super(level);
            this.child = new TrieNode[256];
        }

        @Override
        public int findPartition(BinaryComparable key) {
            int level = this.getLevel();
            if (key.getLength() <= level) {
                return this.child[0].findPartition(key);
            }
            return this.child[0xFF & key.getBytes()[level]].findPartition(key);
        }
    }

    class BinarySearchNode
    implements Node<K> {
        private final K[] splitPoints;
        private final RawComparator<K> comparator;

        BinarySearchNode(K[] splitPoints, RawComparator<K> comparator) {
            this.splitPoints = splitPoints;
            this.comparator = comparator;
        }

        @Override
        public int findPartition(K key) {
            int pos = Arrays.binarySearch(this.splitPoints, key, this.comparator) + 1;
            return pos < 0 ? -pos : pos;
        }
    }

    static abstract class TrieNode
    implements Node<BinaryComparable> {
        private final int level;

        TrieNode(int level) {
            this.level = level;
        }

        int getLevel() {
            return this.level;
        }
    }

    static interface Node<T> {
        public int findPartition(T var1);
    }
}

