/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.impl;

import com.mapr.db.TabletInfo;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.mapreduce.TableInputFormat;
import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.db.mapreduce.impl.DiffTableUtils;
import com.mapr.db.mapreduce.impl.TableSplit;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.ojai.DocumentConstants;
import org.ojai.Value;
import org.ojai.store.QueryCondition;

public class RangeChecksumInputFormat
extends TableInputFormat {
    public static final String SPLITFILENAME = "splitfilename";
    public static final String INCLUDEDREGIONFILENAME = "includedregionfilename";
    private static final Log LOG = LogFactory.getLog(RangeChecksumInputFormat.class);
    private String splitFileName = null;
    private String includedRegionStartPointsFileName = null;
    private List<ByteBufWritableComparable> splitPoints = null;
    private List<ByteBufWritableComparable> includedRegionStartPoints = null;
    private TreeSet<ByteBufWritableComparable> searchableSplitPoints = null;
    private TreeSet<ByteBufWritableComparable> searchableIncludedRegionStartPoints = null;

    @Override
    public void setConf(Configuration configuration) {
        this.splitFileName = configuration.get(SPLITFILENAME, null);
        if (this.splitFileName != null) {
            try {
                Path splitFilePath = new Path(this.splitFileName);
                this.splitPoints = DiffTableUtils.readKeyRange(configuration, splitFilePath);
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("can't read  file " + this.splitFileName + " ", ie);
            }
        }
        this.includedRegionStartPointsFileName = configuration.get(INCLUDEDREGIONFILENAME, null);
        if (this.includedRegionStartPointsFileName != null) {
            try {
                Path includedRegionStartPointsFilePath = new Path(this.includedRegionStartPointsFileName);
                this.includedRegionStartPoints = DiffTableUtils.readKeyRange(configuration, includedRegionStartPointsFilePath);
            }
            catch (IOException ie) {
                throw new IllegalArgumentException("can't read  file " + this.includedRegionStartPointsFileName + " ", ie);
            }
        }
        super.setConf(configuration);
    }

    public ByteBufWritableComparable getSplitStartKey(ByteBufWritableComparable key) {
        ByteBufWritableComparable ret;
        if (this.splitPoints == null) {
            throw new IllegalArgumentException("splitPoints are null from file " + this.splitFileName);
        }
        if (this.searchableSplitPoints == null) {
            this.searchableSplitPoints = new TreeSet<ByteBufWritableComparable>(this.splitPoints);
        }
        if ((ret = this.searchableSplitPoints.floor(key)) == null) {
            ret = this.splitPoints.get(0);
            LOG.warn((Object)("key " + key.toString() + " does not belong to a range. Return first range start key " + ret.toString()));
        }
        return ret;
    }

    protected boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        if (this.includedRegionStartPoints == null) {
            return true;
        }
        if (this.searchableIncludedRegionStartPoints == null) {
            this.searchableIncludedRegionStartPoints = new TreeSet<ByteBufWritableComparable>(this.includedRegionStartPoints);
        }
        ByteBufWritableComparable skey = new ByteBufWritableComparable(ByteBuffer.wrap(startKey));
        boolean ret = this.searchableIncludedRegionStartPoints.contains(skey);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("startKey = (" + startKey + "), endKey = (" + endKey + "), searchableIncludedRegionStartPoints contains startKey = (" + Boolean.toString(ret) + ")"));
        }
        return ret;
    }

    @Override
    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        if (this.splitPoints == null) {
            return super.getSplits(context);
        }
        List<ConditionNode.RowkeyRange> keys = DiffTableUtils.GenStartEndKeys(this.splitPoints);
        LOG.debug((Object)("keyrange number =" + Integer.toString(keys.size())));
        DiffTableUtils.logKeyRanges(keys);
        TabletInfo[] tablets = this.jTable.getTabletInfos();
        String[] dummyLocs = new String[]{new String("dummy host")};
        if (keys == null || keys.isEmpty()) {
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(1);
            TableSplit split = new TableSplit(this.jTable.getName(), (QueryCondition)this.cond, dummyLocs, 0L);
            splits.add(split);
            LOG.debug((Object)("getSplits: split -> 0 -> " + split));
            return splits;
        }
        int i = 0;
        byte[] startRow = new byte[]{};
        byte[] stopRow = new byte[]{};
        if (this.cond != null) {
            List tableKeyRange = this.cond.getRowkeyRanges();
            startRow = ((ConditionNode.RowkeyRange)tableKeyRange.get(0)).getStartRow();
            stopRow = ((ConditionNode.RowkeyRange)tableKeyRange.get(0)).getStopRow();
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(keys.size());
        ListIterator<ConditionNode.RowkeyRange> iter = keys.listIterator(0);
        while (iter.hasNext()) {
            ConditionNode.RowkeyRange k = iter.next();
            if (!this.includeRegionInSplit(k.getStartRow(), k.getStopRow())) {
                LOG.debug((Object)("Range " + i + " : " + k.toString() + " is NOT included"));
                continue;
            }
            LOG.debug((Object)("Range " + i + " : " + k.toString() + " is included"));
            if (startRow.length != 0 && k.getStopRow().length != 0 && Bytes.compareTo((byte[])startRow, (byte[])k.getStopRow()) >= 0 || stopRow.length != 0 && Bytes.compareTo((byte[])stopRow, (byte[])k.getStartRow()) <= 0) continue;
            byte[] splitStart = startRow.length == 0 || Bytes.compareTo((byte[])k.getStartRow(), (byte[])startRow) >= 0 ? k.getStartRow() : startRow;
            byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo((byte[])k.getStopRow(), (byte[])stopRow) <= 0) && k.getStopRow().length > 0 ? k.getStopRow() : stopRow;
            QueryCondition cond = this.getCond(splitStart, splitStop);
            TableSplit split = new TableSplit(this.jTable.getName(), cond, dummyLocs, 0L);
            splits.add(split);
            LOG.debug((Object)("getSplits: split -> " + i + " -> " + split));
            ++i;
        }
        return splits;
    }

    private QueryCondition addCondStarRow(QueryCondition cond, byte[] splitStart) {
        if (splitStart == null) {
            return cond;
        }
        KeyValue splitStartValue = IdCodec.decode((byte[])splitStart);
        Value.Type startType = splitStartValue.getType();
        if (startType == Value.Type.STRING) {
            LOG.debug((Object)("decoded splitStart = (" + splitStartValue.getString() + ")"));
            cond.is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, splitStartValue.getString());
        } else if (startType == Value.Type.BINARY) {
            LOG.debug((Object)("decoded splitStart = (" + Bytes.toStringBinary((ByteBuffer)splitStartValue.getBinary()) + ")"));
            cond.is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, splitStartValue.getBinary());
        } else if (startType == Value.Type.NULL) {
            LOG.debug((Object)("decoded splitStart = (" + Bytes.toStringBinary((byte[])splitStart) + ")"));
            cond.is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, ByteBuffer.wrap(splitStart));
        } else {
            throw new IllegalArgumentException("type of split start is neither binary or string, instead it is " + startType);
        }
        return cond;
    }

    private QueryCondition addCondStopRow(QueryCondition cond, byte[] splitStop) {
        if (splitStop == null) {
            return cond;
        }
        KeyValue splitStopValue = IdCodec.decode((byte[])splitStop);
        Value.Type stopType = splitStopValue.getType();
        if (stopType == Value.Type.STRING) {
            LOG.debug((Object)("decoded splitStop = (" + splitStopValue.getString() + ")"));
            cond.is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, splitStopValue.getString());
        } else if (stopType == Value.Type.BINARY) {
            LOG.debug((Object)("decoded splitStop = (" + Bytes.toStringBinary((ByteBuffer)splitStopValue.getBinary()) + ")"));
            cond.is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, splitStopValue.getBinary());
        } else if (stopType == Value.Type.NULL) {
            LOG.debug((Object)("decoded splitStop = (" + Bytes.toStringBinary((byte[])splitStop) + ")"));
            cond.is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, ByteBuffer.wrap(splitStop));
        } else {
            throw new IllegalArgumentException("type of split stop is neither binary or string, instead it is " + stopType);
        }
        return cond;
    }

    private QueryCondition getCond(byte[] splitStart, byte[] splitStop) {
        ConditionImpl cond = null;
        if (splitStart.length > 0 && splitStop.length > 0) {
            cond = MapRDBImpl.newCondition().and();
            cond = this.addCondStarRow((QueryCondition)cond, splitStart);
            cond = this.addCondStopRow((QueryCondition)cond, splitStop);
            cond.close().build();
        } else if (splitStop.length > 0) {
            cond = MapRDBImpl.newCondition();
            cond = this.addCondStopRow((QueryCondition)cond, splitStop);
            cond.build();
        } else if (splitStart.length > 0) {
            cond = MapRDBImpl.newCondition();
            cond = this.addCondStarRow((QueryCondition)cond, splitStart);
            cond.build();
        } else {
            cond = MapRDBImpl.newCondition().build();
        }
        return cond;
    }
}

