/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.impl.Constants;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.util.ByteBufs;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.ojai.Document;

public class DocumentSerialization
extends Configured
implements Serialization<Document> {
    public boolean accept(Class<?> arg0) {
        return Document.class.isAssignableFrom(arg0);
    }

    public Deserializer<Document> getDeserializer(Class<Document> arg0) {
        return new DocumentDeserializer();
    }

    public Serializer<Document> getSerializer(Class<Document> arg0) {
        return new DocumentSerializer();
    }

    private static class DocumentSerializer
    implements Serializer<Document> {
        OutputStream out;

        private DocumentSerializer() {
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void open(OutputStream out) throws IOException {
            this.out = out;
        }

        public void serialize(Document record) throws IOException {
            int remaining;
            ByteBuffer outBuffer = RowcolCodec.encode((Document)record);
            this.out.write(Bytes.toBytes((int)outBuffer.remaining()));
            int maxRead = 128;
            byte[] buffer = new byte[128];
            while ((remaining = Math.min(outBuffer.remaining(), 128)) > 0) {
                outBuffer.get(buffer, 0, remaining);
                this.out.write(buffer, 0, remaining);
            }
        }
    }

    private static class DocumentDeserializer
    implements Deserializer<Document> {
        DataInputStream d;

        private DocumentDeserializer() {
        }

        public void close() throws IOException {
            this.d.close();
        }

        public Document deserialize(Document record) throws IOException {
            int lenSize = 4;
            byte[] recSize = new byte[4];
            this.d.read(recSize, 0, 4);
            int recordSize = Bytes.toInt((byte[])recSize);
            if (recordSize < 0) {
                throw new IllegalArgumentException("Invalid record size " + recordSize);
            }
            byte[] b = new byte[recordSize];
            this.d.read(b, 0, recordSize);
            ByteBuffer buffer = ByteBufs.wrap((byte[])b);
            HashMap<Integer, ByteBuffer> bufferMap = new HashMap<Integer, ByteBuffer>();
            ByteBuffer cachedBuffer = buffer.duplicate();
            cachedBuffer.order(ByteOrder.LITTLE_ENDIAN);
            bufferMap.put(0, cachedBuffer);
            return RowcolCodec.decode(bufferMap, (Map)Constants.DEFAULT_FAMILY_MAP, (Map)Constants.DEFAULT_NAME_MAP, null, (boolean)true, (boolean)false, (boolean)false, (boolean)false, null);
        }

        public void open(InputStream in) throws IOException {
            this.d = new DataInputStream(in);
        }
    }
}

