/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.mapreduce.TableRecordReader;
import com.mapr.db.mapreduce.impl.MarlinSplitter;
import com.mapr.db.mapreduce.impl.TableSplit;
import com.mapr.db.util.ByteBufs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableInputFormat
extends InputFormat<Value, Document>
implements Configurable {
    static final Logger LOG = LoggerFactory.getLogger(TableInputFormat.class);
    private TableRecordReader recordReader = null;
    protected MapRDBTableImpl jTable;
    private boolean isMarlin;
    protected ConditionImpl cond = null;
    public static final String INPUT_TABLE = "maprdb.mapreduce.inputtable";
    public static final String FIELD_PATH = "maprdb.mapreduce.fieldpath";
    public static final String COND_OBJ = "maprdb.mapreduce.condition";
    public static final String START_ROW = "maprdb.mapreduce.getall.startrow";
    public static final String STOP_ROW = "maprdb.mapreduce.getall.stoprow";
    public static final String EXCLUDE_EMBEDDEDFAMILY = "maprdb.exclude.embedded";
    public static final String GET_DELETES = "maprdb.get.deletes";
    public static final String READ_ALL_CFS = "maprdb.read.all.cfs";
    private Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        TabletInfo[] tablets = this.jTable.getTabletInfos();
        if (this.isMarlin) {
            return MarlinSplitter.getMarlinSplits(this.jTable.getName(), tablets);
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        int i = 1;
        for (TabletInfo tab : tablets) {
            ConditionImpl tabCond = (ConditionImpl)tab.getCondition();
            TableSplit split = new TableSplit(this.jTable.getName(), (QueryCondition)tabCond, tab.getLocations(), tab.getEstimatedSize());
            splits.add(split);
            LOG.debug("getSplits: split -> " + i + " -> " + split);
            ++i;
        }
        return splits;
    }

    public RecordReader<Value, Document> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        TableSplit jSplit = (TableSplit)split;
        if (this.recordReader == null) {
            this.recordReader = new TableRecordReader();
        }
        this.recordReader.setTable((Table)this.jTable);
        ConditionImpl tabletInfoCond = jSplit.getCondition();
        if (this.cond == null) {
            this.recordReader.setCondition((QueryCondition)tabletInfoCond);
        } else {
            ConditionImpl c = (ConditionImpl)MapRDB.newCondition().and().condition((QueryCondition)tabletInfoCond).condition((QueryCondition)this.cond).close().build();
            this.recordReader.setCondition((QueryCondition)c);
        }
        if (conf.get(FIELD_PATH) != null) {
            this.recordReader.setFieldPath(conf.get(FIELD_PATH));
        }
        return this.recordReader;
    }

    public void setConf(Configuration arg0) {
        this.conf = arg0;
        String tableName = this.conf.get(INPUT_TABLE);
        try {
            if (tableName != null) {
                this.jTable = new MapRDBTableImpl(new Path(tableName), this.conf);
                if (this.conf.get("preserve.ts") != null) {
                    this.jTable.setPrivateOption(MapRDBTableImpl.TablePrivateOption.PRESERVE_TIMESTAMP, true);
                }
                this.jTable.setPrivateOption(MapRDBTableImpl.TablePrivateOption.GET_DELETES, this.conf.getBoolean(GET_DELETES, false));
                this.jTable.setPrivateOption(MapRDBTableImpl.TablePrivateOption.EXCLUDE_EMBEDDEDFAMILY, this.conf.getBoolean(EXCLUDE_EMBEDDEDFAMILY, false));
                this.jTable.setOption(Table.TableOption.EXCLUDEID, this.conf.getBoolean("EXCLUDEID", false));
                this.jTable.setPrivateOption(MapRDBTableImpl.TablePrivateOption.READ_ALL_CFS, this.conf.getBoolean(READ_ALL_CFS, true));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        this.isMarlin = ((TableDescriptorImpl)this.jTable.getTableDescriptor()).isStream();
        if (this.conf.get(COND_OBJ) != null) {
            String conditionString = this.conf.get(COND_OBJ);
            this.cond = (ConditionImpl)ConditionImpl.parseFrom((ByteBuffer)ByteBufs.wrap((byte[])Base64.decodeBase64((String)conditionString)));
        }
    }
}

