/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBTableImpl;
import java.io.IOException;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Document;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRecordWriter
extends RecordWriter<Value, Document> {
    static final Logger LOG = LoggerFactory.getLogger(TableRecordWriter.class);
    private Table jTable;
    public static final String OUTPUT_TABLE = "maprdb.mapreduce.outputtable";

    public TableRecordWriter(Table table) {
        this.jTable = table;
        ((MapRDBTableImpl)this.jTable).setPrivateOption(MapRDBTableImpl.TablePrivateOption.PRESERVE_TIMESTAMP, true);
    }

    public void close(TaskAttemptContext context) throws IOException {
        this.jTable.flush();
    }

    public void write(Value key, Document value) throws IOException {
        if (key == null) {
            this.jTable.insertOrReplace(value);
        } else {
            this.jTable.insertOrReplace(key, value);
        }
    }
}

