package com.mapr.db.mapreduce.test;

import static org.junit.Assert.assertEquals;

import org.junit.Test;
import org.junit.experimental.categories.Category;

import com.mapr.db.mapreduce.impl.MapReduceUtilMethods;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;

@Category(SimpleTest.class)
public class TestUtilMethods extends BaseTest {

  @Test
  public void testGetFieldPaths() {
    String paths = "a.b.c,map";
    String[] parsedPaths = MapReduceUtilMethods.getFieldPaths(paths);
    assertEquals("a.b.c", parsedPaths[0]);
    assertEquals("map", parsedPaths[1]);
  }

  @Test
  public void testGetFieldPathsWithQuote() {
    String paths = "\"a,k,.c\",@p#,a.x";
    String[] parsedPaths = MapReduceUtilMethods.getFieldPaths(paths);
    assertEquals("\"a,k,.c\"", parsedPaths[0]);
    assertEquals("@p#", parsedPaths[1]); 
  }

  @Test
  public void testGetFieldPathsWithSingleEntry() {
    String paths = "map.b";
    String[] parsedPaths = MapReduceUtilMethods.getFieldPaths(paths);
    assertEquals("map.b", parsedPaths[0]); 
  }

  @Test
  public void testGetFieldPathsWithQ() {
    String paths = "\"a.k,.c\",\"b,,y\",a.x";
    String[] parsedPaths = MapReduceUtilMethods.getFieldPaths(paths);
    assertEquals("\"a.k,.c\"", parsedPaths[0]);
    assertEquals("\"b,,y\"", parsedPaths[1]); 
  }

}
