package com.mapr.db.mapreduce.test;

import static org.junit.Assert.assertEquals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serializer;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.json.Json;

import com.mapr.db.MapRDB;
import com.mapr.db.mapreduce.DocumentSerialization;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;

@Category(SimpleTest.class)
public class TestDocumentSerialization extends BaseTest {
  
  @Test
  public void testRec() throws Exception {
    DocumentSerialization recSer = new DocumentSerialization();
    Document rec = Json.newDocument();
    rec.set("a.b", "pqr");
    rec.set("a.v", "verbose");
    rec.set("a.x.c", 111);
    rec.set("_id", "k1");
    Serializer<Document> ser = recSer.getSerializer(Document.class);
    DataOutputStream out = new DataOutputStream(new FileOutputStream("test.txt"));
    ser.open(out);
    ser.serialize(rec);
    out.close();

    DataInputStream in = new DataInputStream(new FileInputStream("test.txt"));

    Deserializer<Document> de = recSer.getDeserializer(Document.class);
    de.open(in);
    Document newrec = null;
    newrec = de.deserialize(newrec);
    de.close();

    assertEquals("pqr", newrec.getString("a.b"));
    assertEquals(111, newrec.getInt("a.x.c"));
  }

  @Test
  public void testMultipleRec() throws Exception {
    DocumentSerialization recSer = new DocumentSerialization();
    Document rec = Json.newDocument();
    rec.set("a.b", "pqr");
    rec.set("a.v", "verbose");
    rec.set("a.x.c", 111);
    rec.set("_id","k1");
    Serializer<Document> ser = recSer.getSerializer(Document.class);

    Document rec2 = MapRDB.newDocument();
    rec2.set("a.x", 256);
    rec2.set("a.y", "abc");
    rec2.setId("k2");

    DataOutputStream out = new DataOutputStream(new FileOutputStream("test.txt"));
    ser.open(out);
    ser.serialize(rec);
    ser.serialize(rec2);
    out.close();

    DataInputStream in = new DataInputStream(new FileInputStream("test.txt"));

    Deserializer<Document> de = recSer.getDeserializer(Document.class);
    de.open(in);
    Document newrec = null;
    newrec = de.deserialize(newrec);

    assertEquals("pqr", newrec.getString("a.b"));
    assertEquals(111, newrec.getInt("a.x.c"));

    newrec = de.deserialize(newrec);

    assertEquals("abc", newrec.getString("a.y"));

    de.close();

  }

}
