package com.mapr.db.mapreduce.test;

import static org.junit.Assert.assertEquals;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

import org.junit.Test;
import org.junit.experimental.categories.Category;

import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;

@Category(SimpleTest.class)
public class TestByteBufWritableComparable extends BaseTest {

  @Test
  public void testByteBuf() {
    String s = new String("abracadabra");
    ByteBufWritableComparable bb = new ByteBufWritableComparable();
    byte[] b = s.getBytes(Charset.forName("UTF-8"));
    bb.setByteBuf(ByteBuffer.wrap(b));

    //get it back
    byte[] ret = bb.getBytes();
    try {
      assertEquals("abracadabra", new String(ret, "UTF-8"));
    } catch(Exception e) {
      System.out.println(e.getMessage());
    }
  }

}
