/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.mapreduce.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.ojai.store.QueryCondition;

import com.mapr.db.TableSplitInternal;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.util.ByteBufs;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;

public class TableSplit extends InputSplit implements Writable, Comparable<TableSplit> {

  private TableSplitInternal tableSplitInt;

  public TableSplit() {
   tableSplitInt = new TableSplitInternal();
  }

  public TableSplit(TableSplitInternal intl) {
    tableSplitInt = new TableSplitInternal(intl);
  }

  public TableSplit(String tabName, QueryCondition c, String[] locs, long len) {
    tableSplitInt = new TableSplitInternal(tabName, c, locs, len);
  }

  /**
   * Returns the region's location as an array.
   *
   * @return The array containing the region location.
   * @see org.apache.hadoop.mapreduce.InputSplit#getLocations()
   */
  @Override
  public String[] getLocations() {
    return  tableSplitInt.getLocations();
  }

  public void setLocations(String[] locs) {
    tableSplitInt.setLocations(locs);
  }

  public ConditionImpl getCondition() {
    return tableSplitInt.getCondition();
  }

  /**
   * Returns the length of the split.
   *
   * @return The length of the split.
   * @see org.apache.hadoop.mapreduce.InputSplit#getLength()
   */
  @Override
  public long getLength() {
    return tableSplitInt.getLength();
  }

  byte[] readField(final DataInput in) throws IOException {
    return tableSplitInt.readField(in);
  }

  /**
   * Reads the values of each field.
   *
   * @param in  The input to read from.
   * @throws IOException When reading the input fails.
   */
  @Override
  public void readFields(DataInput in) throws IOException {
    tableSplitInt.readFields(in);
  }

  /**
   * Writes the field values to the output.
   *
   * @param out  The output to write to.
   * @throws IOException When writing the values to the output fails.
   */
  @Override
  public void write(DataOutput out) throws IOException {
    tableSplitInt.write(out);
  }

  /**
   * Returns the details about this instance as a string.
   *
   * @return The values of this instance as a string.
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString() {
    return tableSplitInt.toString();
  }

  public String getTableName() {
    return tableSplitInt.getTableName();
  }

  public byte[] getStartRow() {
    return tableSplitInt.getStartRow();
  }

  public byte[] getStopRow() {
    return tableSplitInt.getStopRow();
  }

  @Override
  /* compare tablename and startrow */
  public int compareTo(TableSplit arg0) {
    int cmpTablename = getTableName().compareTo(arg0.getTableName());
    if (cmpTablename != 0) {
      return cmpTablename;
    }

    byte[] curStartRow = getStartRow();
    byte[] argStartRow = arg0.getStartRow();
    return Bytes.compareTo(curStartRow, argStartRow);
  }

  public TableSplitInternal getTableSplitInt() {
    return tableSplitInt;
  }

  @Override
  public boolean equals(Object o) {
    return tableSplitInt.equals(((TableSplit)o).getTableSplitInt());
  }

    @Override
    public int hashCode() {
      return tableSplitInt.hashCode();
    }
}
