/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.mapreduce.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.hadoop.mapreduce.InputSplit;

import com.mapr.db.TableSplitInternal;
import com.mapr.db.TabletInfo;
import com.mapr.streams.impl.MarlinSplitterCore;

public class MarlinSplitter {

  public static List<InputSplit> getMarlinSplits(String tablename,
                                                         TabletInfo[] tablets)
    throws IOException {

    List<InputSplit> splits = new ArrayList<InputSplit>();
    List<TableSplitInternal> tableSplitInts = MarlinSplitterCore.getMarlinSplits(
                                                                tablename, tablets);

    for (TableSplitInternal tableSplitInt : tableSplitInts) {
      splits.add(new TableSplit(tableSplitInt));
    }

    return splits;
  }
}


