package com.mapr.db.mapreduce.impl;

import java.io.IOException;

import org.apache.hadoop.mapreduce.Mapper;
import org.ojai.Document;
import org.ojai.Value;

import com.mapr.db.impl.IdCodec;

/*
 * mapper will receive the data from binary file in byteswritable format. It has to create records
 * from it.
 */
public class JsonImportMapper extends Mapper<Value, Document,
                                             Value, Document> {

  @Override
  public void map(Value key, Document value, Context context)
      throws IOException, InterruptedException {
    context.write(key, value);
  }
}
