/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.db.mapreduce.impl;

import java.io.IOException;

import org.apache.hadoop.mapreduce.Reducer;
import org.ojai.Document;
import org.ojai.Value;

/*
 * This class loads bulk Ojai records to MapR Document-DB using the BulkLoader
 */
public class JsonBulkLoadReducer extends Reducer<Value, Document, Value, Document> {

  @Override
  public void reduce(Value key, Iterable<Document> values,
                     Context context) throws IOException, InterruptedException {
    for (Document rec : values) {
      if (key != null && rec != null) {
        context.write(key, rec);
      }
    }
  }
}
