package com.mapr.db.mapreduce.impl;

import java.io.IOException;

import org.apache.hadoop.mapreduce.Mapper;
import org.ojai.Document;
import org.ojai.Value;

import com.mapr.db.impl.IdCodec;
import com.mapr.db.rowcol.SequenceFileRowColCodec;

public class ImportMapper extends Mapper<ByteBufWritableComparable, ByteBufWritableComparable,
                                         Value, Document> {

  @Override
  public void map(ByteBufWritableComparable key, ByteBufWritableComparable value, Context context)
      throws IOException, InterruptedException {
    Document doc = SequenceFileRowColCodec.decode(value.getByteBuf());
    context.write(IdCodec.decode(key.getByteBuf()), doc);
  }

}
