package com.mapr.db.mapreduce.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class DocEmptySerialization extends Configured implements Serialization<ByteBufWritableComparable>{

  @Override
  public boolean accept(Class<?> c) {
    return ByteBufWritableComparable.class.isAssignableFrom(c);
  }

  @Override
  public Serializer<ByteBufWritableComparable> getSerializer(Class<ByteBufWritableComparable> c) {
    return new DocEmptySerializer();
  }

  @Override
  public Deserializer<ByteBufWritableComparable> getDeserializer(Class<ByteBufWritableComparable> c) {
    return new DocEmptyDeserializer();
  }

  private static class DocEmptyDeserializer implements Deserializer<ByteBufWritableComparable> {

    DataInputStream d;

    @Override
    public void open(InputStream in) throws IOException {
      d = new DataInputStream(in);
    }

    @Override
    public ByteBufWritableComparable deserialize(ByteBufWritableComparable t) throws IOException {
      ByteBufWritableComparable buffer = new ByteBufWritableComparable();
      buffer.readFields(d);
      return buffer;
    }

    @Override
    public void close() throws IOException {
      d.close();
    }

  }

  private static class DocEmptySerializer implements Serializer<ByteBufWritableComparable> {

    OutputStream out;

    @Override
    public void open(OutputStream out) throws IOException {
      this.out = out;
    }

    @Override
    public void serialize(ByteBufWritableComparable t) throws IOException {
      t.write(new DataOutputStream(out));
    }

    @Override
    public void close() throws IOException {
      out.close();
    }

  }

}
