/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.mapreduce;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Partitioner;
import org.ojai.Document;

import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;

/**
 * <p><code>TablePartitioner</code> controls the partitioning of key space of a JSON
 * table for intermediate map-out functions. The key/id is used to derive the partition.</p>
 */
public class TablePartitioner
  extends Partitioner<ByteBufWritableComparable, Document> implements Configurable {
  /**
   * Gets the partition number for a given key (hence record) given the total
   * number of partitions i.e. number of reduce-tasks for the job.
   *
   * <p>Typically a hash function on a all or a subset of the key.</p>
   *
   * @param key  The key to be partitioned.
   * @param value  The entry value.
   * @param numPartitions  The total number of partitions.
   * @return The partition number for the <code>key</code>.
   * @see org.apache.hadoop.mapreduce.Partitioner#getPartition(
   *   java.lang.Object, java.lang.Object, int)
   */
  @Override
  public int getPartition(ByteBufWritableComparable key,
      Document value, int numPartitions) {
    return 0;
  }

  /**
   * Returns the current configuration.
   *
   * @return The current configuration.
   * @see org.apache.hadoop.conf.Configurable#getConf()
   */
  @Override
  public Configuration getConf() {
    return null;
  }

  /**
   * Sets the configuration. This is used to determine the start keys for the
   * given table.
   *
   * @param configuration  The configuration to set.
   * @see org.apache.hadoop.conf.Configurable#setConf(
   *   org.apache.hadoop.conf.Configuration)
   */
  @Override
  public void setConf(Configuration configuration) {

  }
}
