/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.mapreduce;

import java.io.IOException;

import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBTableImpl;

/**
 * Receives a Record Mutation from Map/Reduce phase and writes to a JSON table.
 */
public class TableMutationRecordWriter extends RecordWriter<Value, DocumentMutation> {

  private MapRDBTableImpl jTable;

  public TableMutationRecordWriter(Table t) {
    jTable = (MapRDBTableImpl) t;
  }

  /**
   * Updates a row given by the key in the table with DocumentMutation.
   *
   * @param key  The key.
   * @param value  DocumentMutation to be used for update.
   * @throws IOException When writing fails.
   * @see org.apache.hadoop.mapreduce.RecordWriter#write(java.lang.Object, java.lang.Object)
   */
  @Override
  public void write(Value key, DocumentMutation value)
      throws IOException, InterruptedException {
    jTable.update(key, value);
  }

  /**
   * Closes the writer, in this case flush table commits.
   *
   * @param context  The context.
   * @throws IOException When closing the writer fails.
   * @see org.apache.hadoop.mapreduce.RecordWriter#close(org.apache.hadoop.mapreduce.TaskAttemptContext)
   */
  @Override
  public void close(TaskAttemptContext context) throws IOException, InterruptedException {
    jTable.flush();
  }

}
