/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.TableMutationRecordWriter;
import com.mapr.db.mapreduce.impl.TableOutputCommitter;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMutationOutputFormat
extends OutputFormat<Value, DocumentMutation>
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(TableMutationOutputFormat.class);
    public static final String OUTPUT_TABLE = "maprdb.mapred.mutation.outputtable";
    private Table jTable = null;
    private Configuration conf = null;
    private String tableName = null;

    public void setConf(Configuration arg0) {
        this.conf = arg0;
        this.tableName = this.conf.get(OUTPUT_TABLE);
        if (this.tableName == null || this.tableName.length() <= 0) {
            throw new IllegalArgumentException("Must specify output table name");
        }
        this.jTable = new MapRDBTableImpl(new Path(this.tableName), this.conf);
        this.jTable.setOption(Table.TableOption.BUFFERWRITE, true);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public RecordWriter<Value, DocumentMutation> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableMutationRecordWriter(this.jTable);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        if (this.jTable == null) {
            throw new IOException("Destination table " + this.tableName + " does not exist");
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableOutputCommitter();
    }
}

