/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.rowcol.IdValueComparator;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.fs.jni.MapRJSONPut;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkLoadRecordWriter
extends RecordWriter<Value, Document> {
    private static final Logger LOG = LoggerFactory.getLogger(BulkLoadRecordWriter.class);
    private final MapRDBTableImpl maprDbTable;
    private long bulkLoaderId;
    private MapRJSONPut prevRecord;
    private int curNumFamilies;
    private Value prevKey;
    private Value curKey;
    private Document curRecord;
    private ByteBuffer curRecordEncoded;
    private List<MapRJSONPut> bufferedPuts;
    private long totalBufferedLen;
    private byte[] tableUuid;
    private Map<FieldPath, Integer> cfIdPathMap = null;
    private SerializedFamilyInfo[] famInfo;
    private IdValueComparator valueComparator;

    public BulkLoadRecordWriter(Configuration conf, Path tablePath) throws IOException, TableNotFoundException {
        this.maprDbTable = new MapRDBTableImpl(tablePath, conf);
        String uuid = conf.get("maprdb.bulkload.uuid");
        this.tableUuid = (byte[])(uuid != null ? Bytes.toBytesBinary((String)uuid) : null);
        this.cfIdPathMap = this.maprDbTable.idPathMap();
        assert (this.cfIdPathMap != null);
        this.totalBufferedLen = 0L;
        this.bufferedPuts = new ArrayList<MapRJSONPut>();
        this.curNumFamilies = 0;
        this.curKey = null;
        this.prevKey = null;
        this.curRecord = null;
        this.curRecordEncoded = null;
        this.prevRecord = null;
        this.famInfo = null;
        this.valueComparator = new IdValueComparator();
    }

    private void open() throws IOException {
        if (this.bulkLoaderId == 0L) {
            this.bulkLoaderId = this.maprDbTable.maprTable().getBulkLoader(this.tableUuid);
        }
    }

    public void write(Value idValue, DocumentMutation mutation) throws IOException, InterruptedException {
        this.open();
        if (idValue == null && mutation == null) {
            this.flush();
            return;
        }
        MutationImpl rmi = (MutationImpl)mutation;
        if (this.prevKey != null) {
            int cmp = this.valueComparator.compareTo(this.prevKey, idValue);
            if (cmp == 0) {
                LOG.warn("Ignoring duplicate key-record");
                return;
            }
            if (cmp > 0) {
                throw new IOException("Received unsorted key-value.");
            }
        }
        if (rmi.needsReadOnServer()) {
            throw new IOException("BulkLoadRecordWriter not supported for RecordMutation that needs read on server.");
        }
        if (this.curKey != null && this.valueComparator.compareTo(this.curKey, idValue) != 0) {
            this.potentiallyFlush();
        }
        if (this.curKey == null) {
            this.curKey = idValue;
        }
        assert (mutation != null);
        this.famInfo = rmi.rowcolSerialize(this.cfIdPathMap, true);
        assert (this.famInfo != null);
        MapRJSONPut mput = new MapRJSONPut(IdCodec.encodeAsBytes((Value)this.curKey), this.famInfo.length);
        this.prevKey = this.curKey;
        block5: for (SerializedFamilyInfo i : this.famInfo) {
            switch (i.getAction()) {
                case NO_ACTION: {
                    continue block5;
                }
                case DELETE_FAMILY: {
                    mput.addCFEntry(i.getFamilyId(), (ByteBuffer)null);
                    continue block5;
                }
                case SET: {
                    mput.addCFEntry(i.getFamilyId(), i.getByteBuffer());
                    continue block5;
                }
                default: {
                    assert ("Invalid Serialization access" == null);
                    continue block5;
                }
            }
        }
        this.totalBufferedLen = mput.recordTotalBytes;
        this.bufferedPuts.add(mput);
    }

    public void write(Value rowKey, Document record) throws IOException, InterruptedException {
        this.open();
        if (rowKey == null && record == null) {
            this.flush();
            return;
        }
        if (this.prevKey != null) {
            int cmp = this.valueComparator.compareTo(this.prevKey, rowKey);
            if (cmp == 0) {
                LOG.warn("Ignoring duplicate key-record");
                return;
            }
            if (cmp > 0) {
                throw new IOException("Received unsorted key-value: prev " + this.prevKey.toString() + " cur " + rowKey.toString());
            }
        }
        if (this.curKey != null && this.valueComparator.compareTo(this.curKey, rowKey) != 0) {
            this.potentiallyFlush();
        }
        if (this.curKey == null) {
            this.curKey = rowKey;
        }
        assert (record != null);
        this.famInfo = RowcolCodec.encode((Document)record, this.cfIdPathMap, (boolean)true, (boolean)true);
        assert (this.famInfo != null);
        MapRJSONPut mput = new MapRJSONPut(IdCodec.encodeAsBytes((Value)this.curKey), this.famInfo.length);
        this.prevKey = this.curKey;
        block5: for (SerializedFamilyInfo i : this.famInfo) {
            switch (i.getAction()) {
                case NO_ACTION: {
                    continue block5;
                }
                case DELETE_FAMILY: {
                    mput.addCFEntry(i.getFamilyId(), (ByteBuffer)null);
                    continue block5;
                }
                case SET: {
                    mput.addCFEntry(i.getFamilyId(), i.getByteBuffer());
                    continue block5;
                }
                default: {
                    assert ("Invalid Serialization access" == null);
                    continue block5;
                }
            }
        }
        this.totalBufferedLen = mput.recordTotalBytes;
        this.bufferedPuts.add(mput);
    }

    private void potentiallyFlush() throws IOException {
        if (this.bufferedPuts.size() >= 100 || this.totalBufferedLen >= 0x100000L) {
            this.flush();
        }
        this.curKey = null;
        this.curRecord = null;
        this.curRecordEncoded = null;
        this.prevRecord = null;
    }

    private void flush() throws IOException {
        if (this.bulkLoaderId == 0L || this.bufferedPuts.size() == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing " + this.bufferedPuts.size() + " records");
        }
        MapRJSONPut[] mputs = this.bufferedPuts.toArray(new MapRJSONPut[this.bufferedPuts.size()]);
        this.maprDbTable.maprTable().bulkLoaderAppendEncoded(this.bulkLoaderId, mputs);
        this.bufferedPuts.clear();
        this.totalBufferedLen = 0L;
    }

    public void close(TaskAttemptContext c) throws IOException, InterruptedException {
        if (this.bulkLoaderId == 0L) {
            return;
        }
        this.flush();
        this.maprDbTable.maprTable().bulkLoaderClose(this.bulkLoaderId);
        this.bulkLoaderId = 0L;
    }
}

