/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.TableRecordWriter;
import com.mapr.db.mapreduce.impl.TableOutputCommitter;
import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Document;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOutputFormat
extends OutputFormat<Value, Document>
implements Configurable {
    static final Logger LOG = LoggerFactory.getLogger(TableOutputFormat.class);
    public static final String OUTPUT_TABLE = "maprdb.mapred.outputtable";
    public static final String ID_FIELD = "maprdb.tableid";
    private Configuration conf = null;
    private Table jTable;

    public RecordWriter<Value, Document> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableRecordWriter(this.jTable);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableOutputCommitter();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration arg0) {
        this.conf = arg0;
        String tableName = this.conf.get(OUTPUT_TABLE);
        if (tableName == null || tableName.length() <= 0) {
            throw new IllegalArgumentException("Must specify output table name");
        }
        this.jTable = new MapRDBTableImpl(new Path(tableName), this.conf);
        this.jTable.setOption(Table.TableOption.BUFFERWRITE, true);
    }
}

