/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.tools;

import com.mapr.db.Admin;
import com.mapr.db.Condition;
import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.mapreduce.BulkLoadOutputFormat;
import com.mapr.db.mapreduce.BulkLoadRecordWriter;
import com.mapr.db.mapreduce.ByteBufWritableComparable;
import com.mapr.db.mapreduce.JsonImportMapper;
import com.mapr.db.mapreduce.TableInputFormat;
import com.mapr.db.mapreduce.TableOutputFormat;
import com.mapr.db.mapreduce.tools.DiffTablesMeta;
import com.mapr.db.mapreduce.tools.MapReduceUtilMethods;
import com.mapr.db.rowcol.DBDocumentImpl;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyTable
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(CopyTable.class);
    private static final String NAME = "CopyTable";
    public static final String TABLE_NAME = "import.table.name";
    private static String srcPath;
    private static String dstPath;
    private static boolean bulkLoad;
    private static boolean mapreduce;
    private static boolean isSuccess;
    private static boolean preserveTimestamps;
    private static boolean keepDeletes;
    private static boolean excludeEmbeddedCF;
    private static String columnSpec;
    private static String startRow;
    private static String stopRow;
    private int numThreads = 16;

    private Job createSubmittableJob(String[] otherArgs) throws IOException {
        Job job = new Job(this.getConf(), "CopyTable_" + srcPath);
        job.setJarByClass(CopyTable.class);
        Configuration conf = job.getConfiguration();
        conf.set("maprdb.mapreduce.inputtable", srcPath);
        conf.setBoolean("maprdb.table.impl.preserve_timestamps", preserveTimestamps);
        conf.setBoolean("maprdb.table.impl.get_deletes", keepDeletes);
        conf.setBoolean("maprdb.table.impl.exclude_embeddedfamily", excludeEmbeddedCF);
        conf.setBoolean("BUFFERWRITE", false);
        if (startRow != null) {
            conf.set("maprdb.mapreduce.getall.startrow", startRow);
        }
        if (stopRow != null) {
            conf.set("maprdb.mapreduce.getall.stoprow", stopRow);
        }
        if (columnSpec != null) {
            conf.set("maprdb.mapreduce.fieldpath", columnSpec);
        }
        job.setInputFormatClass(TableInputFormat.class);
        conf.set(TABLE_NAME, dstPath);
        job.setMapperClass(JsonImportMapper.class);
        MapReduceUtilMethods.setStartStopRow(conf);
        job.setOutputKeyClass(ByteBufWritableComparable.class);
        job.setOutputValueClass(DBDocumentImpl.class);
        this.setupCopyTableSource();
        this.setupCopyTableDestination();
        if (!bulkLoad) {
            job.setOutputFormatClass(TableOutputFormat.class);
            conf.set("maprdb.mapred.outputtable", dstPath);
        } else {
            job.setOutputFormatClass(BulkLoadOutputFormat.class);
            conf.set("maprdb.mapreduce.bulkloadrecordwriter.outputTable", dstPath);
        }
        job.setNumReduceTasks(0);
        return job;
    }

    private void createTableForCopy(Admin maprAdmin, String dstPath, String srcPath) throws IOException {
        TableDescriptor dstTableDesc = maprAdmin.getTableDescriptor(srcPath);
        dstTableDesc.setPath(dstPath);
        dstTableDesc.setBulkLoad(bulkLoad);
        maprAdmin.createTable(dstTableDesc);
    }

    private void Usage(String errMsg) {
        if (errMsg != null) {
            System.err.println("ERROR: " + errMsg);
        }
        System.err.println("Usage: CopyTable [Options] -src <source table path> -dst <destination table path>\nOptions:\n[-startRow <start key>]\n[-stopRow <end key>]\n[-columns cf1[:col1],...]\n[-bulkload <true|false> (default: true)]\n[-mapreduce <true|false> (default: true)]\n[-numthreads <number of threads> (default: 16)");
        System.exit(1);
    }

    private void ParseArgs(String[] args) throws Exception {
        ArrayList<String> cmpArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-src")) {
                cmpArgs.add(args[i]);
                srcPath = args[++i];
                cmpArgs.add(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-dst")) {
                cmpArgs.add(args[i]);
                dstPath = args[++i];
                cmpArgs.add(args[i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-columns")) {
                columnSpec = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-bulkload")) {
                bulkLoad = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-startRow")) {
                startRow = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-stopRow")) {
                stopRow = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapreduce")) {
                mapreduce = Boolean.valueOf(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads")) {
                this.numThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-preserve_ts")) {
                preserveTimestamps = Boolean.valueOf(args[++i]);
                continue;
            }
            this.Usage(null);
        }
        if (srcPath == null || dstPath == null) {
            this.Usage("missing -src or -dst.");
        }
        if (startRow != null && stopRow != null && startRow.compareTo(stopRow) < 0) {
            this.Usage("stopRow is smaller than startRow.");
        }
        Admin admin = MapRDB.newAdmin();
        if (preserveTimestamps) {
            if (admin.tableExists(dstPath)) {
                cmpArgs.add("-columns");
                cmpArgs.add("-Aces");
                int ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new DiffTablesMeta(false), (String[])cmpArgs.toArray(new String[cmpArgs.size()]));
                if (ret == 0) {
                    LOG.info("Metadata of the two tables matches.");
                } else if (ret == 1) {
                    throw new Exception("Metadata of " + srcPath + " and " + dstPath + " is different.");
                }
            }
        } else {
            keepDeletes = false;
        }
        mapreduce = false;
        columnSpec = MapReduceUtilMethods.processColumnSpec(columnSpec, srcPath);
        LOG.info("Copying {} column families from {} to {}.", new Object[]{columnSpec != null ? columnSpec : "all", srcPath, dstPath});
        TableDescriptorImpl desc = (TableDescriptorImpl)admin.getTableDescriptor(srcPath);
        if (desc.isStream()) {
            excludeEmbeddedCF = true;
        }
    }

    private void setupCopyTableSource() throws IOException {
        Admin maprAdmin = MapRDB.newAdmin();
        if (((TableDescriptorImpl)maprAdmin.getTableDescriptor(srcPath)).isStream()) {
            bulkLoad = false;
        }
    }

    private void setupCopyTableDestination() throws IOException {
        Admin maprAdmin = MapRDB.newAdmin();
        if (!maprAdmin.tableExists(dstPath)) {
            this.createTableForCopy(maprAdmin, dstPath, srcPath);
        }
    }

    private void Cleanup() throws IOException {
        Admin maprAdmin = MapRDB.newAdmin();
        TableDescriptor dstTableDesc = maprAdmin.getTableDescriptor(dstPath);
        if (dstTableDesc.isBulkLoad()) {
            dstTableDesc.setBulkLoad(false);
        }
        maprAdmin.alterTable(dstTableDesc);
    }

    private int run_NoMR(String[] args) throws IOException, Exception {
        Configuration config = this.getConf();
        config.setBoolean("maprdb.table.impl.preserve_timestamps", preserveTimestamps);
        config.setBoolean("maprdb.table.impl.get_deletes", keepDeletes);
        config.setBoolean("maprdb.table.impl.exclude_embeddedfamily", excludeEmbeddedCF);
        config.setBoolean("BUFFERWRITE", false);
        this.setupCopyTableSource();
        this.setupCopyTableDestination();
        Table srcTable = MapRDB.getTable((String)srcPath);
        TabletInfo[] tabletInfos = srcTable.getTabletInfos();
        int numSplits = tabletInfos.length;
        long ts = System.currentTimeMillis();
        ExecutorService executor = Executors.newFixedThreadPool(this.numThreads);
        ArrayList futures = new ArrayList();
        for (int i = 0; i < numSplits; ++i) {
            Future<?> f = executor.submit(new LoaderThread(i, tabletInfos[i], config));
            futures.add(f);
        }
        for (Future<?> f : futures) {
            f.get();
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        if (!isSuccess) {
            return 1;
        }
        this.Cleanup();
        return 0;
    }

    public int run(String[] args) throws Exception {
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        if (otherArgs.length < 2) {
            this.Usage("Wrong number of arguments: " + otherArgs.length);
            System.exit(-1);
        }
        this.ParseArgs(otherArgs);
        if (!mapreduce) {
            return this.run_NoMR(otherArgs);
        }
        Job job = this.createSubmittableJob(otherArgs);
        if (!job.waitForCompletion(true)) {
            LOG.error("CopyTable MapReduce job failed !!");
            return 1;
        }
        this.Cleanup();
        return 0;
    }

    public static boolean copy(final String[] args, String user) throws Exception {
        UserGroupInformation ugi = CopyTable.createUser(user);
        LOG.info("Running copytable job " + mapreduce + " as user: " + user);
        if (!mapreduce) {
            System.out.println("No map-reduce");
        }
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    int status = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTable(), (String[])args);
                    if (status == 0) {
                        CopyTable.setJobSuccessful();
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception while running copytable job: " + e);
                    throw new Exception(e.getMessage());
                }
                return null;
            }
        });
        return isSuccess;
    }

    public static void setJobSuccessful() {
        isSuccess = true;
    }

    public static void main(String[] args) throws Exception {
        int ret = 0;
        try {
            ret = ToolRunner.run((Configuration)new Configuration(), (Tool)new CopyTable(), (String[])args);
        }
        catch (Exception e) {
            ret = 1;
            e.printStackTrace();
        }
        System.exit(ret);
    }

    private static UserGroupInformation createUser(String user) throws IOException {
        return UserGroupInformation.createRemoteUser((String)user);
    }

    static {
        bulkLoad = true;
        mapreduce = true;
        isSuccess = false;
        preserveTimestamps = true;
        keepDeletes = true;
        excludeEmbeddedCF = false;
        columnSpec = null;
        startRow = null;
        stopRow = null;
    }

    class LoaderThread
    extends BaseLoaderThread {
        LoaderThread(int id, TabletInfo t, Configuration config) {
            super(id, t, config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BulkLoadRecordWriter writer = null;
            Condition c = this.tabletInfo.getCondition();
            MapRDBTableImpl srcTable = null;
            MapRDBTableImpl destTable = null;
            try {
                srcTable = new MapRDBTableImpl(new Path(srcPath), this.config);
                DocumentStream rs = null;
                rs = columnSpec != null ? srcTable.find(c, columnSpec.split(",")) : srcTable.find(c);
                Iterator iterator = rs.iterator();
                if (bulkLoad) {
                    writer = new BulkLoadRecordWriter(CopyTable.this.getConf(), new Path(dstPath));
                    while (iterator.hasNext()) {
                        DBDocument r = (DBDocument)iterator.next();
                        writer.write(new ByteBufWritableComparable(IdCodec.encode((Value)r.getId())), r);
                    }
                    writer.close(null);
                } else {
                    destTable = new MapRDBTableImpl(new Path(dstPath), this.config);
                    while (iterator.hasNext()) {
                        DBDocument r = (DBDocument)iterator.next();
                        destTable.insertOrReplace(r.getId(), (Document)r);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("CopyTable encountered an exception: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                try {
                    if (srcTable != null) {
                        srcTable.close();
                    }
                    if (destTable != null) {
                        destTable.flush();
                        destTable.close();
                    }
                }
                catch (Exception e) {
                    LOG.error("CopyTable encountered an exception: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            CopyTable.setJobSuccessful();
        }
    }

    abstract class BaseLoaderThread
    implements Runnable {
        protected TabletInfo tabletInfo;
        protected int myid;
        protected Configuration config;

        protected BaseLoaderThread(int id, TabletInfo t, Configuration config) {
            this.myid = id;
            this.tabletInfo = t;
            this.config = config;
        }
    }
}

