/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.Condition;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.util.ByteBufs;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class TableSplit
extends InputSplit
implements Writable,
Comparable<TableSplit> {
    private String tableName;
    private ConditionImpl cond;
    private String[] locations = null;
    private long length;

    public TableSplit() {
    }

    public TableSplit(String tabName, Condition c, String[] locs, long len) {
        this.tableName = tabName;
        this.cond = (ConditionImpl)c;
        this.locations = locs;
        this.length = len;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public void setLocations(String[] locs) {
        this.locations = locs;
    }

    public ConditionImpl getCondition() {
        return this.cond;
    }

    public long getLength() {
        return this.length;
    }

    byte[] readField(DataInput in) throws IOException {
        int len = in.readInt();
        byte[] buff = new byte[len];
        in.readFully(buff);
        return buff;
    }

    public void readFields(DataInput in) throws IOException {
        this.tableName = new String(this.readField(in), "UTF-8");
        this.cond = (ConditionImpl)ConditionImpl.parseFrom((ByteBuffer)ByteBufs.wrap((byte[])this.readField(in)));
        this.locations = new String[]{new String(this.readField(in), "UTF-8")};
        this.length = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        byte[] tabName = this.tableName.getBytes(Charset.forName("UTF-8"));
        out.writeInt(tabName.length);
        out.write(tabName);
        ByteBuffer buff = this.cond.getDescriptor().getSerialized();
        int condBuffLength = buff.remaining();
        byte[] condBytes = new byte[condBuffLength];
        condBytes = Bytes.getBytes((ByteBuffer)buff);
        out.writeInt(condBuffLength);
        out.write(condBytes);
        byte[] locationsInBytes = this.concatLocationString().getBytes(Charset.forName("UTF-8"));
        out.writeInt(locationsInBytes.length);
        out.write(locationsInBytes);
        out.writeLong(this.length);
    }

    private String concatLocationString() {
        return Arrays.toString(this.locations);
    }

    public String toString() {
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public byte[] getStartRow() {
        return ((ConditionNode.RowkeyRange)this.cond.getRowkeyRanges().get(0)).getStartRow();
    }

    public byte[] getStopRow() {
        return ((ConditionNode.RowkeyRange)this.cond.getRowkeyRanges().get(0)).getStopRow();
    }

    @Override
    public int compareTo(TableSplit arg0) {
        int cmpTablename = this.tableName.compareTo(arg0.getTableName());
        if (cmpTablename != 0) {
            return cmpTablename;
        }
        ConditionImpl argCond = arg0.getCondition();
        byte[] curStartRow = ((ConditionNode.RowkeyRange)this.cond.getRowkeyRanges().get(0)).getStartRow();
        byte[] argStartRow = ((ConditionNode.RowkeyRange)argCond.getRowkeyRanges().get(0)).getStartRow();
        return Bytes.compareTo((byte[])curStartRow, (byte[])argStartRow);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TableSplit)) {
            return false;
        }
        return this.tableName.equals(((TableSplit)o).tableName) && this.cond.equals((Object)((TableSplit)o).getCondition()) && this.locations.equals(((TableSplit)o).locations);
    }

    public int hashCode() {
        int result = this.tableName != null ? this.tableName.hashCode() : 0;
        result = 31 * result + (this.cond != null ? this.cond.hashCode() : 0);
        result = 31 * result + (this.locations != null ? Arrays.hashCode(this.locations) : 0);
        return result;
    }
}

