/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.Condition;
import com.mapr.db.DBDocument;
import com.mapr.db.Table;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.mapreduce.ByteBufWritableComparable;
import com.mapr.db.mapreduce.TableMapReduceUtil;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRecordReaderImpl {
    static final Logger LOG = LoggerFactory.getLogger(TableRecordReaderImpl.class);
    private ByteBufWritableComparable key = null;
    private DBDocument value = null;
    private Table jTable = null;
    private TaskAttemptContext context = null;
    DocumentStream<DBDocument> rs = null;
    Iterator<DBDocument> recordIterator = null;
    private Condition cond = null;
    private String[] fieldPaths = null;

    public void close() {
        try {
            this.jTable.close();
        }
        catch (Exception e) {
            LOG.warn("Error closing table " + e.getMessage());
        }
    }

    public ByteBufWritableComparable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public DBDocument getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.key = null;
        this.value = null;
        if (this.recordIterator.hasNext()) {
            this.value = this.recordIterator.next();
            this.key = new ByteBufWritableComparable();
            this.key.setByteBuf(IdCodec.encode((Value)this.value.getId()));
            return true;
        }
        return false;
    }

    public void initialize(InputSplit inputsplit, TaskAttemptContext cntxt) throws IOException, InterruptedException {
        if (cntxt != null) {
            this.context = cntxt;
        }
        this.rs = this.cond != null ? (this.fieldPaths != null ? this.jTable.find(this.cond, this.fieldPaths) : this.jTable.find(this.cond)) : (this.fieldPaths != null ? this.jTable.find(this.fieldPaths) : this.jTable.find());
        if (this.rs != null) {
            this.recordIterator = this.rs.iterator();
        }
    }

    public void setTable(Table t) {
        this.jTable = t;
    }

    public void setCondition(Condition c) {
        this.cond = c;
    }

    public void setFieldPath(String fieldPath) {
        this.fieldPaths = TableMapReduceUtil.getFieldPaths(fieldPath);
    }
}

