/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.Condition;
import com.mapr.db.DBConstants;
import com.mapr.db.MapRDB;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.mapreduce.TableSplit;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.mapreduce.InputSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinSplitter {
    static final Logger LOG = LoggerFactory.getLogger(MarlinSplitter.class);
    private static final String SEMICOLON = ";";
    private static final String UTF8 = "UTF-8";
    private static final char COLON = ':';

    private static String GetTopicEndKey(String key) {
        if (key == null || key.length() == 0) {
            return null;
        }
        int topicEndIndex = key.indexOf(58);
        if (topicEndIndex < 0) {
            return null;
        }
        return key.substring(0, topicEndIndex) + SEMICOLON;
    }

    public static void getMarlinSplits(String tablename, TabletInfo[] tablets, List<InputSplit> splits) throws IOException {
        String nextStartKey = null;
        for (int i = 0; i < tablets.length; ++i) {
            int j;
            String curEndKey;
            String topicEndKey;
            TabletInfo tab = tablets[i];
            ConditionImpl cond = (ConditionImpl)tab.getCondition();
            List rowKeys = cond.getRowkeyRanges();
            if (nextStartKey == null) {
                nextStartKey = new String(((ConditionNode.RowkeyRange)rowKeys.get(0)).getStartRow(), UTF8);
            }
            if ((topicEndKey = MarlinSplitter.GetTopicEndKey(curEndKey = new String(((ConditionNode.RowkeyRange)rowKeys.get(rowKeys.size() - 1)).getStopRow(), UTF8))) == null) {
                Condition splitCond = MapRDB.newCondition().and().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER_OR_EQUAL, nextStartKey).is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS, curEndKey).close().build();
                TableSplit split = new TableSplit(tablename, splitCond, tab.getLocations(), tab.getEstimatedSize());
                splits.add(split);
                LOG.trace("Adding MarlinSplits with endKey [" + nextStartKey + ", " + curEndKey + ")");
                nextStartKey = null;
                continue;
            }
            for (j = i + 1; j < tablets.length; ++j) {
                TabletInfo nextTab = tablets[j];
                ConditionImpl nextCond = (ConditionImpl)nextTab.getCondition();
                List nextRowKeys = nextCond.getRowkeyRanges();
                String nextEndKey = new String(((ConditionNode.RowkeyRange)nextRowKeys.get(nextRowKeys.size() - 1)).getStopRow(), UTF8);
                if (topicEndKey.compareTo(nextEndKey) > 0) continue;
                Condition splitCond = MapRDB.newCondition().and().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER_OR_EQUAL, nextStartKey).is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS, topicEndKey).close().build();
                TableSplit split = new TableSplit(tablename, splitCond, tab.getLocations(), tab.getEstimatedSize());
                splits.add(split);
                LOG.trace("Adding MarlinSplits with topicEndKey [" + nextStartKey + ", " + topicEndKey + ")");
                nextStartKey = topicEndKey;
                i = j - 1;
                break;
            }
            assert (j < tablets.length);
        }
    }
}

