/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce;

import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.mapreduce.BulkLoadRecordWriter;
import com.mapr.db.mapreduce.ByteBufWritableComparable;
import com.mapr.db.mapreduce.TableOutputCommitter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkLoadOutputFormat
extends OutputFormat<ByteBufWritableComparable, Document>
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(BulkLoadOutputFormat.class);
    public static final String OUTPUT_TABLE = "maprdb.mapreduce.bulkloadrecordwriter.outputTable";
    private static Table table = null;
    private static String tableName = null;
    private Configuration conf = null;

    public void setConf(Configuration conf) {
        this.conf = conf;
        if (tableName == null) {
            tableName = conf.get(OUTPUT_TABLE);
        } else assert (tableName == conf.get(OUTPUT_TABLE));
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("Complete Output Table path must be specified");
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public RecordWriter<ByteBufWritableComparable, Document> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.createRecordWriter(context);
    }

    private RecordWriter<ByteBufWritableComparable, Document> createRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        table = BulkLoadOutputFormat.getTable(tableName);
        Path tablePath = new Path(tableName);
        return new BulkLoadRecordWriter(this.conf, tablePath);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableOutputCommitter();
    }

    private static Table getTable(String tabName) throws IOException {
        tableName = tabName;
        try (Admin admin = MapRDB.newAdmin();){
            if (!admin.tableExists(tableName)) {
                table = admin.createTable(MapRDB.newTableDescriptor((String)tabName).setBulkLoad(true));
            }
            table = MapRDB.getTable((String)tableName);
        }
        catch (TableNotFoundException e) {
            LOG.info("Table not found. Creating table " + tableName + " with bulkload=true.");
        }
        return table;
    }

    public static List<ByteBufWritableComparable> getPartitionSplitPoints(String tabName) throws IOException {
        TabletInfo[] tabletInfo = BulkLoadOutputFormat.getTable(tabName).getTabletInfos();
        assert (tabletInfo.length >= 1);
        ArrayList<ByteBufWritableComparable> startKeys = new ArrayList<ByteBufWritableComparable>();
        for (TabletInfo ti : tabletInfo) {
            List range = ((ConditionImpl)ti.getCondition()).getRowkeyRanges();
            startKeys.add(new ByteBufWritableComparable(ByteBuffer.wrap(((ConditionNode.RowkeyRange)range.get(0)).getStartRow())));
        }
        return startKeys;
    }
}

