/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test.repl;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.DBDocument;
import com.mapr.db.Table;
import com.mapr.db.mapreduce.tools.DiffTables;
import com.mapr.db.mapreduce.tools.Import;
import com.mapr.db.tests.tableops.TestMapRDBWithCluster;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.IntegrationTest;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTest.class})
public class TestRepl
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestRepl.class);
    private static final String SRC_TABLE_NAME = "/srctable";
    private static final String DST_TABLE_NAME = "/dsttable";
    private static final String DIFF_TABLE_OUT_DIR = "/tmp/difftables";

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        DBTests.deleteTables((String[])new String[]{SRC_TABLE_NAME});
        DBTests.deleteTables((String[])new String[]{DST_TABLE_NAME});
    }

    void setupReplication(String srcTable, String dstTable, Boolean paused) throws InterruptedException, IOException {
        ProcessBuilder proc = new ProcessBuilder("maprcli", "table", "replica", "add", "-path", srcTable, "-replica", dstTable, "-paused", paused.toString());
        Process replicaAdd = proc.start();
        replicaAdd.waitFor();
        _logger.info("Replica add process exit code: {}", (Object)replicaAdd.exitValue());
        Assert.assertEquals((long)0L, (long)replicaAdd.exitValue());
        proc = new ProcessBuilder("maprcli", "table", "upstream", "add", "-path", dstTable, "-upstream", srcTable);
        Process upstreamAdd = proc.start();
        upstreamAdd.waitFor();
        _logger.info("Upstream add process exit code: {}", (Object)upstreamAdd.exitValue());
        Assert.assertEquals((long)0L, (long)upstreamAdd.exitValue());
        Thread.sleep(10000L);
    }

    void rmDir(String path) throws IOException, InterruptedException {
        ProcessBuilder proc = new ProcessBuilder("hadoop", "fs", "-rmr", path);
        Process p = proc.start();
        p.waitFor();
    }

    void comapreTables(String srcTable, String dstTable, boolean expectedPass) throws Exception {
        String outdir = DIFF_TABLE_OUT_DIR;
        this.rmDir(outdir);
        int ret = ToolRunner.run(null, (Tool)new DiffTables(), (String[])new String[]{"-src", srcTable, "-dst", dstTable, "-outdir", outdir});
        if (expectedPass) {
            Assert.assertEquals((long)0L, (long)ret);
        }
    }

    private void importFromDir(String dstTableName, String srcDir) throws IOException, InterruptedException, Exception {
        int ret = ToolRunner.run(null, (Tool)new Import(), (String[])new String[]{"-src", srcDir, "-dst", dstTableName, "-bulkload", "false", "-mapreduce", "false"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    private void formatResult(String inDir, String outDir) throws IOException, InterruptedException {
        this.rmDir(outDir);
        ProcessBuilder proc = new ProcessBuilder("maprdb", "formatresult", "-indir", inDir, "-outdir", outDir);
        _logger.info("Running command {}", proc.command());
        Process p = proc.start();
        p.waitFor();
        _logger.info("formatresult process exit code: {}", (Object)p.exitValue());
        Assert.assertEquals((long)0L, (long)p.exitValue());
    }

    @Test
    public void testSingleFamilyReplication() throws Exception {
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME);
        this.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), Boolean.FALSE);
        Document d = TestMapRDBWithCluster.getMedRecord();
        for (int i = 0; i < 100000; ++i) {
            srcTable.insertOrReplace("key" + i, d);
        }
        srcTable.flush();
        Thread.sleep(10000L);
        _logger.info("Comparing tables");
        this.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), true);
    }

    @Test
    public void testSingleColumnFamily2() throws Exception {
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME);
        this.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), Boolean.TRUE);
        Document d = TestMapRDBWithCluster.getMedRecord();
        for (int i = 0; i < 100000; ++i) {
            srcTable.insertOrReplace("key" + i, d);
        }
        srcTable.flush();
        Thread.sleep(30000L);
        this.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false);
        this.formatResult("/tmp/difftables/OpsForDstTable", "/tmp/difftables/OpsForDstTableDecoded");
        this.formatResult("/tmp/difftables/OpsForSrcTable", "/tmp/difftables/OpsForSrcTableDecoded");
        this.importFromDir(dstTable.getPath().toString(), "/tmp/difftables/OpsForDstTable");
        this.importFromDir(srcTable.getPath().toString(), "/tmp/difftables/OpsForSrcTable");
        this.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), true);
        DocumentStream s = srcTable.find();
        Iterator siter = s.iterator();
        DocumentStream d2 = dstTable.find();
        Iterator diter = d2.iterator();
        for (int i = 0; i < 100000; ++i) {
            DBDocument sdoc = (DBDocument)siter.next();
            DBDocument ddoc = (DBDocument)diter.next();
            Assert.assertEquals((Object)sdoc, (Object)ddoc);
        }
    }

    @Test
    public void testMultipleColumnFamily2() throws Exception {
        ImmutableMap sm = ImmutableMap.of((Object)"map", (Object)"map", (Object)"Friends", (Object)"Friends", (Object)"dummy", (Object)"dummy");
        ImmutableMap dm = ImmutableMap.of((Object)"Friends", (Object)"Friends", (Object)"dummy", (Object)"dummy", (Object)"map", (Object)"map");
        Table srcTable = DBTests.createOrReplaceTable((String)SRC_TABLE_NAME, (Map)sm);
        Table dstTable = DBTests.createOrReplaceTable((String)DST_TABLE_NAME, (Map)dm);
        this.setupReplication(srcTable.getPath().toString(), dstTable.getPath().toString(), Boolean.TRUE);
        Document d = TestMapRDBWithCluster.getMedRecord();
        for (int i = 0; i < 100000; ++i) {
            srcTable.insertOrReplace("key" + i, d);
        }
        srcTable.flush();
        Thread.sleep(30000L);
        this.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), false);
        this.formatResult("/tmp/difftables/OpsForDstTable", "/tmp/difftables/OpsForDstTableDecoded");
        this.formatResult("/tmp/difftables/OpsForSrcTable", "/tmp/difftables/OpsForSrcTableDecoded");
        this.importFromDir(dstTable.getPath().toString(), "/tmp/difftables/OpsForDstTable");
        this.importFromDir(srcTable.getPath().toString(), "/tmp/difftables/OpsForSrcTable");
        _logger.info("src table" + srcTable.getName().toString() + "dst table" + dstTable.getPath().toString() + " " + DIFF_TABLE_OUT_DIR + "/" + "OpsForDstTable");
        this.comapreTables(srcTable.getPath().toString(), dstTable.getPath().toString(), true);
        DocumentStream s = srcTable.find();
        Iterator siter = s.iterator();
        DocumentStream d2 = dstTable.find();
        Iterator diter = d2.iterator();
        for (int i = 0; i < 100000; ++i) {
            DBDocument sdoc = (DBDocument)siter.next();
            DBDocument ddoc = (DBDocument)diter.next();
            Assert.assertEquals((Object)sdoc, (Object)ddoc);
        }
    }
}

