/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.mapreduce.ByteBufWritableComparable;
import com.mapr.db.rowcol.SequenceFileRowColCodec;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.fs.MapRFileSystem;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.Value;

@Category(value={ClusterTest.class})
public class TestMCFEncodingDecoding
extends BaseTest {
    private SequenceFile.Writer writer = null;
    FileSystem fs = null;
    String filePath = DBTests.getTestRoot() + "/fpath";
    String tableName = "mcftab1";
    String tabname2 = "mcftab2";
    Configuration conf = null;

    private void setUp() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf1", "a.b");
        cfPath.put("cf2", "a.c");
        DBTests.deleteTables((String[])new String[]{this.tableName});
        Table myTab = DBTests.createOrReplaceTable((String)this.tableName, cfPath);
        DBDocument d = MapRDB.newDocument();
        d.set("a.b", 1234).set("a.c.x1", true).set("a.c.x2", "eureka").set("a.e", "pqr");
        myTab.insertOrReplace("k1", (Document)d);
        myTab.insertOrReplace("k2", (Document)d);
        myTab.flush();
        myTab.close();
    }

    public void setUp2() throws Exception {
        this.setUp();
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf1", "a.b");
        cfPath.put("cf2", "a.c");
        DBTests.deleteTables((String[])new String[]{this.tabname2});
        Table myTab = DBTests.createOrReplaceTable((String)this.tabname2, cfPath);
        myTab.close();
    }

    private void createWriter() throws Exception {
        this.conf = new Configuration();
        this.fs = MapRFileSystem.get((Configuration)this.conf);
        this.writer = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.conf, (Path)new Path(this.filePath), ByteBufWritableComparable.class, ByteBufWritableComparable.class);
    }

    @Test
    public void testMCFEncoding() throws Exception {
        this.setUp();
        this.createWriter();
        MapRDBTableImpl myTab = (MapRDBTableImpl)DBTests.getTable((String)this.tableName);
        myTab.setPrivateOption(MapRDBTableImpl.TablePrivateOption.PRESERVE_TIMESTAMP, true);
        for (DBDocument d : myTab.find()) {
            ByteBuffer id = IdCodec.encode((Value)d.getId());
            ByteBuffer encodedDocument = SequenceFileRowColCodec.encode((Document)d);
            this.writer.append((Writable)new ByteBufWritableComparable(id), (Writable)new ByteBufWritableComparable(encodedDocument));
        }
        this.writer.close();
        SequenceFile.Reader reader = new SequenceFile.Reader(this.fs, new Path(this.filePath), this.conf);
        ByteBufWritableComparable key = new ByteBufWritableComparable();
        ByteBufWritableComparable value = new ByteBufWritableComparable();
        while (reader.next((Writable)key, (Writable)value)) {
            DBDocument docValue = SequenceFileRowColCodec.decode((ByteBuffer)value.getByteBuf());
            Assert.assertEquals((Object)true, (Object)docValue.getBoolean("a.c.x1"));
        }
        reader.close();
    }

    @Test
    public void test2() throws Exception {
        this.setUp2();
        MapRDBTableImpl myTab = (MapRDBTableImpl)DBTests.getTable((String)this.tableName);
        myTab.setPrivateOption(MapRDBTableImpl.TablePrivateOption.PRESERVE_TIMESTAMP, true);
        MapRDBTableImpl tab2 = (MapRDBTableImpl)DBTests.getTable((String)this.tableName);
        for (DBDocument d : myTab.find()) {
            tab2.insertOrReplace(d.getId(), (Document)d);
        }
        tab2.flush();
        myTab.close();
        tab2.close();
    }
}

