/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.db;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.mapr.client.impl.Constant;
import com.mapr.client.impl.Fid;
import com.mapr.client.impl.MapRClient;
import com.mapr.client.impl.clients.MfsClient;
import com.mapr.fs.proto.Dbserver;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class TabletScanner {
    private TabletScanner() {
    }

    private static void addTabletDescListToMap(RangeMap<ByteBuf, Fid> tabletMap, List<Dbserver.TabletDesc> tdescList, ConcurrentHashMap<Fid, Fid> reverseTabletMap, Fid tableFid) {
        for (Dbserver.TabletDesc tdesc : tdescList) {
            ByteBuf startKey = Unpooled.wrappedBuffer((ByteBuffer)tdesc.getStartKey().asReadOnlyByteBuffer()).order(ByteOrder.BIG_ENDIAN);
            ByteBuf endKey = Unpooled.wrappedBuffer((ByteBuffer)tdesc.getEndKey().asReadOnlyByteBuffer()).order(ByteOrder.BIG_ENDIAN);
            if (tdesc.getStartKey().size() == 0) {
                startKey = Constant.MIN_ROW_KEY;
            }
            if (tdesc.getEndKey().size() == 0) {
                endKey = Constant.MAX_ROW_KEY;
            }
            Range keyRange = Range.closedOpen((Comparable)startKey, (Comparable)endKey);
            Fid tabletFid = new Fid(tdesc.getFid());
            tabletMap.put(keyRange, (Object)tabletFid);
            reverseTabletMap.put(tabletFid, tableFid);
        }
    }

    public static void invalidateTabletMap(RangeMap<ByteBuf, Fid> tabletMap, ConcurrentHashMap<Fid, Fid> reverseTabletMap) {
        Collection tabletFidList = tabletMap.asMapOfRanges().values();
        for (Fid tabletFid : tabletFidList) {
            reverseTabletMap.remove(tabletFid);
        }
        tabletMap.clear();
    }

    public static void populateTabletMap(MapRClient client, Fid tableFid, RangeMap<ByteBuf, Fid> tabletMap, ByteBuf rowKey, ConcurrentHashMap<Fid, Fid> reverseTabletMap) throws Exception {
        MfsClient mc = client.getMfsClientFromContainerId(tableFid.getCid());
        ByteBuf startKey = rowKey == null ? Constant.MIN_ROW_KEY : rowKey;
        Dbserver.TabletLookupResponse tresp = (Dbserver.TabletLookupResponse)mc.tabletLookup(tableFid, startKey, 500).join();
        int numTotalTablets = 0;
        int numFound = 0;
        numTotalTablets = tresp.getNumTotalTablets();
        TabletScanner.addTabletDescListToMap(tabletMap, tresp.getDescList(), reverseTabletMap, tableFid);
        startKey = Unpooled.wrappedBuffer((ByteBuffer)tresp.getDesc(numFound - 1).getEndKey().asReadOnlyByteBuffer());
        for (numFound = tresp.getDescCount(); numFound < numTotalTablets; numFound += tresp.getDescCount()) {
            tresp = (Dbserver.TabletLookupResponse)mc.tabletLookup(tableFid, startKey, 500).join();
            TabletScanner.addTabletDescListToMap(tabletMap, tresp.getDescList(), reverseTabletMap, tableFid);
        }
    }
}

