/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.rpc;

import com.mapr.client.impl.LifeCycle;
import com.mapr.client.impl.MapRClient;
import com.stumbleupon.async.Deferred;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class RpcBinding
implements LifeCycle {
    protected int epoch;
    protected final AtomicInteger nextConnId;
    protected final AtomicInteger nextCallId;
    protected final MapRClient mapRClient;
    private boolean isStarted;

    protected RpcBinding(MapRClient mapRClient) {
        this.mapRClient = mapRClient;
        this.nextCallId = new AtomicInteger(0);
        this.nextConnId = new AtomicInteger(0);
    }

    protected abstract void startBinding();

    protected abstract void stopBinding();

    @Override
    public final Deferred<Object> start() {
        this.startBinding();
        this.epoch = this.mapRClient.nextEpoh();
        this.isStarted = true;
        return null;
    }

    @Override
    public Deferred<Object> stop() {
        this.stopBinding();
        this.isStarted = false;
        return null;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    public int nextCallId() {
        return this.nextCallId.incrementAndGet();
    }

    public int nextConnId() {
        return this.nextConnId.incrementAndGet();
    }

    public EventLoopGroup getClientEventLoopGroup() {
        return this.mapRClient.getClientEventLoopGroup();
    }

    public boolean isSecure() {
        return this.mapRClient.isSecure();
    }

    public MapRClient getMapRClient() {
        return this.mapRClient;
    }
}

