/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.rpc;

import com.google.protobuf.MessageLite;
import com.mapr.client.impl.memory.Allocator;
import com.mapr.client.impl.rpc.RpcMessage;
import com.mapr.utils.Crypto;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import mapr.fs.Rpcheader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
class RpcMsgEncoder
extends MessageToMessageEncoder<RpcMessage> {
    private static final Logger logger = LoggerFactory.getLogger(RpcMsgEncoder.class);
    private final boolean secure;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final RpcMsgEncoder SIMPLE_ENCODER = new RpcMsgEncoder(false);
    private static final RpcMsgEncoder SECURED_ENCODER = new RpcMsgEncoder(true);

    public RpcMsgEncoder(boolean secure) {
        this.secure = secure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, RpcMessage msg, List<Object> out) throws Exception {
        if (this.secure) {
            throw new UnsupportedOperationException("Secure connections are not supported!");
        }
        if (!ctx.channel().isOpen()) {
            logger.debug("Channel closed, skipping encode.");
            msg.release();
            return;
        }
        try {
            Rpcheader.RpcHeader hdr = msg.getHeader();
            int hdrLen = hdr.getSerializedSize();
            byte[] hdrBytes = hdr.toByteArray();
            MessageLite req = msg.getRequest();
            int reqLen = req.getSerializedSize();
            byte[] reqBytes = reqLen == 0 ? EMPTY_BYTE_ARRAY : req.toByteArray();
            ByteBuf payload = msg.getPayload();
            int payloadLen = payload.readableBytes();
            int ticketLen = 0;
            byte[] ticketBytes = EMPTY_BYTE_ARRAY;
            int signedHdrLen = hdrLen;
            int signedMsgLen = reqLen;
            int signedPayloadLen = payloadLen;
            int totalLen = this.secure ? 4 + ticketLen : 0;
            ByteBuf buf = ctx.alloc().buffer((totalLen += 3 + signedHdrLen + 3 + 1 + signedMsgLen + signedPayloadLen) + 4 - signedPayloadLen).order(ByteOrder.BIG_ENDIAN);
            ByteBufOutputStream os = new ByteBufOutputStream(buf);
            os.writeInt(totalLen);
            if (this.secure) {
                os.write(1);
                this.writeInt24(os, ticketLen);
            }
            os.writeShort(hdrLen);
            this.writeInt24(os, reqLen);
            os.write((int)Crypto.computeXor((byte[])hdrBytes));
            os.write((int)Crypto.computeXor((byte[])reqBytes));
            os.write(ticketBytes);
            os.write(hdrBytes);
            os.write(reqBytes);
            if (signedPayloadLen > 0) {
                buf = Allocator.wrappedBuffer(buf, payload);
            }
            out.add(buf);
        }
        finally {
            msg.release();
        }
    }

    private void writeInt24(ByteBufOutputStream os, int v) throws IOException {
        os.write(v & 0xFF);
        os.write(v >> 8 & 0xFF);
        os.write(v >> 16 & 0xFF);
    }

    public static ChannelHandler get(boolean secure) {
        return secure ? SECURED_ENCODER : SIMPLE_ENCODER;
    }
}

