/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.rpc;

import com.mapr.client.impl.MapRClient;
import com.mapr.client.impl.annotations.Shared;
import com.mapr.client.impl.rpc.NettyHelper;
import com.mapr.client.impl.rpc.RpcBinding;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServer
extends RpcBinding {
    private static final Logger logger = LoggerFactory.getLogger(RpcServer.class);
    @Shared
    protected final ServerBootstrap bootstrap;
    private volatile int port;
    protected Channel channel;

    protected RpcServer(MapRClient maprClient, int port) {
        super(maprClient);
        this.port = port;
        this.bootstrap = NettyHelper.newServerBootstrap(maprClient.getServerEventLoopGroup(), new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                logger.debug("Channel {} initialzed.", (Object)ch);
            }
        });
    }

    @Override
    protected void startBinding() {
        try {
            this.channel = this.bootstrap.bind(this.port).sync().channel();
            if (this.port == 0) {
                InetSocketAddress s = (InetSocketAddress)this.channel.localAddress();
                this.port = s.getPort();
            }
            logger.debug("{} listening on port {}.", (Object)this.getClass().getSimpleName(), (Object)this.port);
        }
        catch (InterruptedException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void stopBinding() {
        this.bootstrap.group().shutdownGracefully();
    }

    public int getPort() {
        return this.port;
    }
}

