/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.rpc;

import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLiteOrBuilder;
import com.mapr.client.impl.rpc.RpcResponse;
import com.stumbleupon.async.Deferred;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteOrder;
import mapr.fs.Rpcheader;

public abstract class RpcMessage {
    protected static final int RPC_VERSION_1 = 1;
    protected static final int RPC_VERSION_CURRENT = 1;
    protected static final ByteBuf EMPTY_PAYLOAD = Unpooled.EMPTY_BUFFER;
    protected final Rpcheader.RpcHeader.Builder hdrBuilder;
    protected Rpcheader.RpcHeader hdr;
    protected final MessageLiteOrBuilder reqMsgOrBuilder;
    protected MessageLite req;
    protected boolean isBuilt = false;
    protected Deferred<Object> deferred;

    public RpcMessage(int programId, int procedureId, MessageLiteOrBuilder reqMsgOrBuilder) {
        this.reqMsgOrBuilder = reqMsgOrBuilder;
        this.hdrBuilder = Rpcheader.RpcHeader.newBuilder().setVersion(1).setProgramProc(programId << 16 | procedureId).setRequest(true);
    }

    final Deferred<Object> getDeferred() {
        if (this.deferred == null) {
            this.deferred = new Deferred();
        }
        return this.deferred;
    }

    public Object parseResponse(RpcResponse response) throws IOException {
        assert (response.getHdr().getProgramProc() == this.hdr.getProgramProc());
        return this.parseResponse0(response);
    }

    protected abstract Object parseResponse0(RpcResponse var1) throws IOException;

    public ByteBuf getPayload() {
        ByteBuf p = this.getPayload0();
        assert (p.order() == ByteOrder.BIG_ENDIAN);
        return p;
    }

    protected ByteBuf getPayload0() {
        return EMPTY_PAYLOAD;
    }

    public Rpcheader.RpcHeader getHeader() {
        Preconditions.checkState((boolean)this.isBuilt());
        return this.hdr;
    }

    public MessageLite getRequest() {
        Preconditions.checkState((boolean)this.isBuilt());
        return this.req;
    }

    public RpcMessage setEpoch(int epoh) {
        this.hdrBuilder.setEpoch(epoh);
        return this;
    }

    public long getSequenceId() {
        return this.hdrBuilder.getSequence();
    }

    public RpcMessage setSequenceId(long sequenceId) {
        this.hdrBuilder.setSequence(sequenceId);
        return this;
    }

    public RpcMessage setCallId(int callId) {
        this.hdrBuilder.setCallid(callId);
        return this;
    }

    public RpcMessage setConnId(int connId) {
        this.hdrBuilder.setConnid(connId);
        return this;
    }

    public boolean isBuilt() {
        return this.isBuilt;
    }

    public void release() {
    }

    public void build() {
        this.isBuilt = true;
        this.hdr = this.hdrBuilder.build();
        this.req = this.reqMsgOrBuilder instanceof MessageLite ? (MessageLite)this.reqMsgOrBuilder : ((MessageLite.Builder)this.reqMsgOrBuilder).build();
    }

    public void callback(Object result) {
        Deferred<Object> d = this.deferred;
        if (d == null) {
            return;
        }
        this.deferred = null;
        d.callback(result);
    }
}

