/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.tests.rpc;

import com.mapr.client.impl.Fid;
import com.mapr.client.impl.clients.MfsClient;
import com.mapr.client.tests.rpc.DbClientBaseTest;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Fileserver;
import com.mapr.tests.annotations.ClusterTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class ContainerLookupTest
extends DbClientBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ContainerLookupTest.class);

    @Test
    public void testContainerLookup() throws Exception {
        int containerId = 2049;
        CLDBProto.ContainerLookupResponse cresp = (CLDBProto.ContainerLookupResponse)cldb.containerLookup(containerId).join();
        int port = cresp.getContainers(0).getMServer().getIps(0).getPort();
        logger.debug("containerId={}", (Object)port);
        Assert.assertEquals((long)port, (long)5660L);
        MfsClient mc = client.getMfsClientFromContainerId(containerId);
        Fileserver.LookupResponse lresp = (Fileserver.LookupResponse)mc.lookup("table1", client.getRootFid()).join();
        logger.debug("response={}" + lresp.getChild().getCinum());
        Fid returnFid = client.doPathWalk("/table1", null);
        logger.debug("response={}" + returnFid.getInum());
        Assert.assertEquals((long)lresp.getChild().getCid(), (long)returnFid.getCid());
    }
}

