/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.util;

import com.google.common.base.Preconditions;
import com.mapr.utils.ByteReader;
import io.netty.buffer.ByteBuf;

public class ByteBufReader
extends ByteReader {
    private final int baseIdx;
    private final int length;
    private final ByteBuf buffer;

    private ByteBufReader(ByteBuf buff) {
        Preconditions.checkNotNull((Object)buff);
        this.buffer = buff;
        this.length = buff.readableBytes();
        this.baseIdx = buff.readerIndex();
    }

    public int length() {
        return this.length;
    }

    public byte nextUnsafe() {
        return this.buffer.readByte();
    }

    public byte getByte(int idx) {
        return this.buffer.getByte(this.baseIdx + idx);
    }

    public ByteReader mark() {
        this.buffer.markReaderIndex();
        return this;
    }

    public ByteReader reset() {
        this.buffer.resetReaderIndex();
        return this;
    }

    public static ByteReader wrap(ByteBuf buff) {
        return new ByteBufReader(buff);
    }
}

