/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.impl;

import com.mapr.baseutils.BinaryString;
import com.mapr.db.ControlInfo;
import com.mapr.db.cdc.impl.ChangeNodeImpl;
import com.mapr.db.ojai.DBDocumentReader2;
import com.mapr.db.ojai.DBDocumentReaderBase;
import com.mapr.db.ojai.EventTypeWithTime;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.TimeAndUniq;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.store.cdc.ChangeEvent;
import org.ojai.store.cdc.ChangeOp;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Internal
public class ChangeDataDBDocumentReader
extends DBDocumentReaderBase {
    private ChangeNodeImpl currentChangeNode_ = null;
    private ChangeNodeImpl nextChangeNode_ = null;
    boolean hasNextChangeNode_ = false;
    private DBDocumentReader2 dbReader_ = null;
    private EventTypeWithTime currentEventTypeWithTime_ = null;
    private Queue<ChangeNodeImpl> nodeQueue_ = null;
    private ChangeNodeImpl lastNodeInQueue_ = null;
    private long rowTS_ = 0L;
    private long opBaseTime_ = 0L;
    TimeAndUniq[] rootTS_ = null;
    private boolean doneSearchRootTS_ = false;
    boolean isRegionCopy_ = false;
    ChangeOp rowOp_ = null;
    int currentLevel = 0;
    static final Logger LOG = LoggerFactory.getLogger(ChangeDataDBDocumentReader.class);

    public ChangeDataDBDocumentReader(DBDocumentReader2 dbReader, long rowTS, long opBaseTime, ChangeOp rowOp) throws IllegalArgumentException {
        if (dbReader == null) {
            throw new IllegalArgumentException("DBDocumentReader2 is null.");
        }
        this.dbReader_ = dbReader;
        this.currentChangeNode_ = new ChangeNodeImpl();
        this.nextChangeNode_ = new ChangeNodeImpl();
        this.hasNextChangeNode_ = false;
        this.currentEventTypeWithTime_ = new EventTypeWithTime();
        this.nodeQueue_ = new LinkedList<ChangeNodeImpl>();
        this.lastNodeInQueue_ = null;
        this.doneSearchRootTS_ = false;
        this.rowTS_ = rowTS;
        this.opBaseTime_ = opBaseTime;
        this.isRegionCopy_ = this.rowTS_ == 0L;
        this.rowOp_ = rowOp;
    }

    private Value getCachedCurrentValue(DocumentReader.EventType eventType) {
        switch (eventType) {
            case BOOLEAN: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getBoolean());
            }
            case STRING: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getString());
            }
            case BYTE: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getByte());
            }
            case SHORT: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getShort());
            }
            case FLOAT: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getFloat());
            }
            case INT: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getInt());
            }
            case DOUBLE: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getDouble());
            }
            case LONG: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getLong());
            }
            case DECIMAL: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getDecimal());
            }
            case DATE: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getDate());
            }
            case TIME: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getTime());
            }
            case TIMESTAMP: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getTimestamp());
            }
            case INTERVAL: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getInterval());
            }
            case BINARY: {
                return DBValueBuilderImpl.KeyValueBuilder.initFrom(this.dbReader_.getBinary());
            }
        }
        throw new IllegalStateException("EventType(" + eventType + ") is not a Value Type, cannot turn into a ojai Value.");
    }

    public ChangeNodeImpl nextChangeDataNode() {
        if (!this.nodeQueue_.isEmpty()) {
            ChangeNodeImpl tmpNode = this.nodeQueue_.remove();
            this.currentChangeNode_.setValues(tmpNode.getEvent(), tmpNode.getOp(), tmpNode.getOpTimestamp(), tmpNode.getServerTimestamp(), tmpNode.getFieldName(), tmpNode.getArrayIndex(), tmpNode.getArrayIndexTime(), tmpNode.getValue(), tmpNode.inMap(), true);
            return this.currentChangeNode_;
        }
        this.lastNodeInQueue_ = null;
        return this.nextChangeDataNodeInternal();
    }

    private static ChangeNodeImpl correctEvent(ChangeNodeImpl node) {
        if (node.getOp() == ChangeOp.DELETE && (node.getEvent() == ChangeEvent.START_MAP || node.getEvent() == ChangeEvent.START_ARRAY)) {
            node.setEvent(ChangeEvent.NODE);
        }
        return node;
    }

    private ChangeNodeImpl nextChangeDataNodeInternal() {
        if (this.hasNextChangeNode_) {
            this.hasNextChangeNode_ = false;
            this.currentChangeNode_.setValues(this.nextChangeNode_.getEvent(), this.nextChangeNode_.getOp(), this.nextChangeNode_.getOpTimestamp(), this.nextChangeNode_.getServerTimestamp(), this.nextChangeNode_.getFieldName(), this.nextChangeNode_.getArrayIndex(), this.nextChangeNode_.getArrayIndexTime(), this.nextChangeNode_.getValue(), this.nextChangeNode_.inMap(), true);
            this.nextChangeNode_.ResetValues();
            return this.currentChangeNode_;
        }
        DocumentReader.EventType et = this.dbReader_.nextEventWithTime(this.currentEventTypeWithTime_);
        if (et == null) {
            return null;
        }
        ChangeEvent event = null;
        boolean hasValue = false;
        ChangeOp defaultOp = null;
        if (et.compareTo((Enum)DocumentReader.EventType.NULL) == 0) {
            event = ChangeEvent.NODE;
            defaultOp = ChangeOp.SET;
        } else if (et.compareTo((Enum)DocumentReader.EventType.START_MAP) == 0) {
            event = ChangeEvent.START_MAP;
            defaultOp = ChangeOp.MERGE;
        } else if (et.compareTo((Enum)DocumentReader.EventType.END_MAP) == 0) {
            event = ChangeEvent.END_MAP;
            defaultOp = ChangeOp.MERGE;
        } else if (et.compareTo((Enum)DocumentReader.EventType.START_ARRAY) == 0) {
            event = ChangeEvent.START_ARRAY;
            defaultOp = ChangeOp.MERGE;
        } else if (et.compareTo((Enum)DocumentReader.EventType.END_ARRAY) == 0) {
            event = ChangeEvent.END_ARRAY;
            defaultOp = ChangeOp.MERGE;
        } else {
            event = ChangeEvent.NODE;
            hasValue = true;
            defaultOp = ChangeOp.SET;
        }
        this.rootTS_ = this.dbReader_.getRootTS();
        TimeAndUniq createTime = null;
        switch (this.currentEventTypeWithTime_.getCreateTimeState()) {
            case NOT_SET: 
            case NOT_VALID: {
                createTime = null;
                break;
            }
            case VALID_WITH_REFTIME: {
                createTime = this.currentEventTypeWithTime_.getCreateTime();
                if (createTime.time() != 0L) break;
                if (this.rootTS_ != null && !this.isTSZero(this.rootTS_)) {
                    createTime = this.rootTS_[0];
                    break;
                }
                createTime.setTime(this.rowTS_);
                break;
            }
            case VALID_WITH_EXTERNAL_TIME: {
                createTime = this.currentEventTypeWithTime_.getCreateTime();
            }
        }
        TimeAndUniq updateTime = null;
        switch (this.currentEventTypeWithTime_.getUpdateTimeState()) {
            case NOT_SET: 
            case NOT_VALID: {
                updateTime = null;
                break;
            }
            case VALID_WITH_REFTIME: {
                updateTime = this.currentEventTypeWithTime_.getUpdateTime();
                if (updateTime.time() != 0L) break;
                if (this.rootTS_ != null && !this.isTSZero(this.rootTS_)) {
                    updateTime = this.rootTS_[1];
                    break;
                }
                updateTime.setTime(this.rowTS_);
                break;
            }
            case VALID_WITH_EXTERNAL_TIME: {
                updateTime = this.currentEventTypeWithTime_.getUpdateTime();
            }
        }
        TimeAndUniq deleteTime = null;
        switch (this.currentEventTypeWithTime_.getDeleteTimeState()) {
            case NOT_SET: 
            case NOT_VALID: {
                deleteTime = null;
                break;
            }
            case VALID_WITH_REFTIME: {
                deleteTime = this.currentEventTypeWithTime_.getDeleteTime();
                if (deleteTime.time() != 0L) break;
                if (this.rootTS_ != null && !this.isTSZero(this.rootTS_)) {
                    deleteTime = this.rootTS_[2];
                    break;
                }
                deleteTime.setTime(this.rowTS_);
                break;
            }
            case VALID_WITH_EXTERNAL_TIME: {
                deleteTime = this.currentEventTypeWithTime_.getDeleteTime();
            }
        }
        if (createTime == null && updateTime == null && deleteTime == null) {
            Value value = null;
            if (hasValue) {
                value = this.getCachedCurrentValue(et);
            }
            ChangeOp tmpOp = null;
            long tmpOpTime = 0L;
            if (event == ChangeEvent.START_MAP || event == ChangeEvent.START_ARRAY) {
                tmpOp = this.currentLevel == 0 ? this.rowOp_ : defaultOp;
                ++this.currentLevel;
            } else {
                --this.currentLevel;
                tmpOp = this.currentLevel == 0 ? this.rowOp_ : defaultOp;
            }
            tmpOpTime = this.opBaseTime_;
            this.currentChangeNode_.setValues(event, tmpOp, tmpOpTime, tmpOpTime, this.dbReader_.inMap() ? this.dbReader_.getFieldName() : null, this.dbReader_.inMap() ? -1 : this.dbReader_.getArrayIndex(), this.dbReader_.inMap() ? null : this.dbReader_.getArrayIndexTime(), value, this.dbReader_.inMap(), true);
            ChangeDataDBDocumentReader.correctEvent(this.currentChangeNode_);
            return this.currentChangeNode_;
        }
        if (updateTime == null) {
            throw new IllegalStateException("ChangeData has delete time(" + deleteTime.time() + ") and create time(" + createTime.time() + "), but no update time!");
        }
        ChangeOp op = null;
        long opTime = 0L;
        ChangeOp nextOp = null;
        long nextOpTime = 0L;
        Value opValue = null;
        Value nextOpValue = null;
        if (event != ChangeEvent.NODE) {
            if (deleteTime == null) {
                if (createTime == null) {
                    op = ChangeOp.MERGE;
                    opTime = updateTime.time();
                } else if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) == 0) {
                    op = this.rowOp_ != null ? this.rowOp_ : (this.isRegionCopy_ ? ChangeOp.SET : ChangeOp.MERGE);
                    opTime = createTime.time();
                } else if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) < 0) {
                    op = ChangeOp.MERGE;
                    opTime = updateTime.time();
                } else {
                    LOG.info("Bug26626 b1: ChangeData create time(" + createTime.time() + ") should be equal to or less than update time(" + updateTime.time() + ")");
                    op = ChangeOp.MERGE;
                    opTime = updateTime.time();
                }
            } else if (createTime == null) {
                if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) == 0) {
                    op = ChangeOp.DELETE;
                    opTime = deleteTime.time();
                } else if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) < 0) {
                    op = ChangeOp.DELETE;
                    opTime = deleteTime.time();
                    nextOp = ChangeOp.MERGE;
                    nextOpTime = updateTime.time();
                } else {
                    LOG.info("Bug26626 b2: ChangeData delete time(" + deleteTime.time() + ") should be equal to or less than update time(" + updateTime.time() + ")");
                    op = ChangeOp.DELETE;
                    opTime = deleteTime.time();
                    nextOp = ChangeOp.MERGE;
                    nextOpTime = updateTime.time();
                }
            } else {
                if (deleteTime.time() == 0L && createTime.time() == 0L && updateTime.time() == 0L) {
                    Value value = null;
                    if (hasValue) {
                        value = this.getCachedCurrentValue(et);
                    }
                    this.currentChangeNode_.setValues(event, ChangeOp.NULL, 0L, 0L, this.dbReader_.inMap() ? this.dbReader_.getFieldName() : null, this.dbReader_.inMap() ? -1 : this.dbReader_.getArrayIndex(), this.dbReader_.inMap() ? null : this.dbReader_.getArrayIndexTime(), value, this.dbReader_.inMap(), true);
                    return this.currentChangeNode_;
                }
                if (updateTime.time() == 0L) {
                    throw new IllegalStateException("ChangeData has create time(" + createTime.time() + " and update time " + updateTime.time() + ", but updateTime is 0");
                }
                if (deleteTime.time() == 0L) {
                    if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) == 0) {
                        op = this.rowOp_ != null ? this.rowOp_ : (this.isRegionCopy_ ? ChangeOp.SET : ChangeOp.MERGE);
                        opTime = createTime.time();
                    } else if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) < 0) {
                        op = ChangeOp.MERGE;
                        opTime = updateTime.time();
                    } else {
                        LOG.info("Bug26626 b3: ChangeData create time(" + createTime.time() + ") should be equal to or less than update time(" + updateTime.time() + ")");
                        op = ChangeOp.MERGE;
                        opTime = updateTime.time();
                    }
                } else if (createTime.time() == 0L) {
                    if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) == 0) {
                        op = ChangeOp.DELETE;
                        opTime = deleteTime.time();
                    } else if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) < 0) {
                        op = ChangeOp.DELETE;
                        opTime = deleteTime.time();
                        nextOp = ChangeOp.MERGE;
                        nextOpTime = updateTime.time();
                    } else {
                        LOG.info("Bug26626 b4: ChangeData delete time(" + deleteTime.time() + ") should be equal to or less than update time(" + updateTime.time() + ")");
                        op = ChangeOp.DELETE;
                        opTime = deleteTime.time();
                        nextOp = ChangeOp.MERGE;
                        nextOpTime = updateTime.time();
                    }
                } else if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) == 0 || TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) == 0) {
                    op = ChangeOp.SET;
                    opTime = updateTime.time();
                } else if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) == 0) {
                    if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) > 0) {
                        LOG.info("Bug26626 b5: ChangeData create time(" + createTime.time() + " should be equal to or less than update time(" + updateTime.time());
                    }
                    op = ChangeOp.DELETE;
                    opTime = deleteTime.time();
                } else if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) == 0) {
                    if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) > 0) {
                        LOG.info("Bug26626 b6: ChangeData delete time(" + deleteTime.time() + " should be equal to or less than update time(" + updateTime.time());
                    }
                    op = this.rowOp_ != null ? this.rowOp_ : (this.isRegionCopy_ ? ChangeOp.SET : ChangeOp.MERGE);
                    opTime = updateTime.time();
                } else {
                    if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) > 0) {
                        LOG.info("Bug26626 b7: ChangeData create time(" + createTime.time() + " should be equal to or less than update time(" + updateTime.time());
                    }
                    if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) > 0) {
                        LOG.info("Bug26626 b8: ChangeData delete time(" + deleteTime.time() + " should be equal to or less than update time(" + updateTime.time());
                    }
                    op = ChangeOp.MERGE;
                    opTime = updateTime.time();
                }
            }
        } else {
            if (deleteTime == null) {
                if (createTime == null) {
                    throw new IllegalStateException("Leaf node has only update time " + updateTime);
                }
                if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) > 0) {
                    LOG.info("Bug26626 b9: Leaf node create time(" + createTime.time() + ") > update time(" + updateTime.time() + ")");
                }
                op = ChangeOp.SET;
                opTime = createTime.time();
            } else if (createTime == null) {
                if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) > 0) {
                    LOG.info("Bug26626 b10: ChangeData leaf node delete time(" + deleteTime.time() + ") > update time(" + updateTime.time() + ")");
                }
                op = ChangeOp.DELETE;
                opTime = deleteTime.time();
            } else if (createTime.time() == 0L && updateTime.time() == 0L && deleteTime.time() == 0L) {
                op = ChangeOp.SET;
                opTime = updateTime.time();
            } else {
                if (updateTime.time() == 0L) {
                    throw new IllegalStateException("ChangeData leaf node has delete time(" + deleteTime.time() + ") and create time(" + createTime.time() + ", but update time is 0");
                }
                if (deleteTime.time() == 0L) {
                    if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) > 0) {
                        LOG.info("Bug26626 b11: ChangeData leaf node create time(" + createTime.time() + ") should be less than or equal to update time(" + updateTime.time() + ")");
                    }
                    op = ChangeOp.SET;
                    opTime = updateTime.time();
                } else if (createTime.time() == 0L) {
                    if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) > 0) {
                        LOG.info("Bug26626 b12: ChangeData leaf node delete time(" + deleteTime.time() + ") should be less than or equal to update time(" + updateTime.time() + ")");
                    }
                    op = ChangeOp.DELETE;
                    opTime = deleteTime.time();
                } else if (TimeAndUniq.equals((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) && TimeAndUniq.equals((TimeAndUniq)createTime, (TimeAndUniq)updateTime)) {
                    op = ChangeOp.SET;
                    opTime = createTime.time();
                } else if (TimeAndUniq.equals((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime)) {
                    if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) > 0) {
                        LOG.info("Bug26626 b13: ChangeData leaf node create time(" + createTime.time() + ") should be equal to or less than update time(" + updateTime.time() + ")");
                    }
                    op = ChangeOp.DELETE;
                    opTime = deleteTime.time();
                } else if (TimeAndUniq.equals((TimeAndUniq)createTime, (TimeAndUniq)updateTime)) {
                    if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) > 0) {
                        throw new IllegalStateException("ChangeData leaf node delete time(" + deleteTime.time() + ") should be equal to or less than update time(" + updateTime.time() + ")");
                    }
                    op = ChangeOp.SET;
                    opTime = createTime.time();
                } else if (deleteTime.time() == 0L) {
                    if (TimeAndUniq.cmp((TimeAndUniq)createTime, (TimeAndUniq)updateTime) > 0) {
                        LOG.info("Bug26626 b14: ChangeData leaf node create time(" + createTime.time() + ") should be equal to or less than update time(" + updateTime.time() + ")");
                    }
                    op = ChangeOp.SET;
                    opTime = updateTime.time();
                } else if (createTime.time() == 0L) {
                    if (TimeAndUniq.cmp((TimeAndUniq)deleteTime, (TimeAndUniq)updateTime) > 0) {
                        throw new IllegalStateException("ChangeData leaf node delete time(" + deleteTime.time() + ") should be equal to or less than update time(" + updateTime.time() + ")");
                    }
                    op = ChangeOp.DELETE;
                    opTime = deleteTime.time();
                } else {
                    throw new IllegalStateException("ChangeData leaf node has all three times, then they should be the same. But it has create time(" + createTime.time() + ") update time(" + updateTime.time() + ") delete time(" + deleteTime.time() + ")");
                }
            }
            if (op == ChangeOp.DELETE) {
                opValue = null;
                if (nextOp != null && hasValue) {
                    nextOpValue = this.getCachedCurrentValue(et);
                }
            } else {
                opValue = null;
                if (hasValue) {
                    opValue = this.getCachedCurrentValue(et);
                }
                if (nextOp != null) {
                    nextOpValue = opValue;
                }
            }
        }
        if (nextOp != null) {
            this.nextChangeNode_.setValues(event, nextOp, nextOpTime, nextOpTime, this.dbReader_.inMap() ? this.dbReader_.getFieldName() : null, this.dbReader_.inMap() ? -1 : this.dbReader_.getArrayIndex(), this.dbReader_.inMap() ? null : this.dbReader_.getArrayIndexTime(), nextOpValue, this.dbReader_.inMap(), true);
            ChangeDataDBDocumentReader.correctEvent(this.nextChangeNode_);
            this.hasNextChangeNode_ = true;
        }
        this.currentChangeNode_.setValues(event, op, opTime, opTime, this.dbReader_.inMap() ? this.dbReader_.getFieldName() : null, this.dbReader_.inMap() ? -1 : this.dbReader_.getArrayIndex(), this.dbReader_.inMap() ? null : this.dbReader_.getArrayIndexTime(), opValue, this.dbReader_.inMap(), true);
        ChangeDataDBDocumentReader.correctEvent(this.currentChangeNode_);
        return this.currentChangeNode_;
    }

    public int getArrayIndex() {
        return this.currentChangeNode_.getArrayIndex();
    }

    public TimeAndUniq getArrayIndexTime() {
        return this.currentChangeNode_.getArrayIndexTime();
    }

    public ByteBuffer getBinary() {
        return this.currentChangeNode_.getValue().getBinary();
    }

    public boolean getBoolean() {
        return this.currentChangeNode_.getValue().getBoolean();
    }

    public byte getByte() {
        return this.currentChangeNode_.getValue().getByte();
    }

    public ODate getDate() {
        return this.currentChangeNode_.getValue().getDate();
    }

    public int getDateInt() {
        return this.currentChangeNode_.getValue().getDateAsInt();
    }

    public BigDecimal getDecimal() {
        return this.currentChangeNode_.getValue().getDecimal();
    }

    public int getDecimalPrecision() {
        return this.currentChangeNode_.getValue().getDecimal().precision();
    }

    public int getDecimalScale() {
        return this.currentChangeNode_.getValue().getDecimal().scale();
    }

    public ByteBuffer getDecimalValueAsBytes() {
        throw new UnsupportedOperationException();
    }

    public int getDecimalValueAsInt() {
        return this.currentChangeNode_.getValue().getDecimal().intValue();
    }

    public long getDecimalValueAsLong() {
        return this.currentChangeNode_.getValue().getDecimal().longValue();
    }

    public double getDouble() {
        return this.currentChangeNode_.getValue().getDouble();
    }

    public String getFieldName() {
        return this.currentChangeNode_.getFieldName();
    }

    public float getFloat() {
        return this.currentChangeNode_.getValue().getFloat();
    }

    public int getInt() {
        return this.currentChangeNode_.getValue().getInt();
    }

    public OInterval getInterval() {
        return this.currentChangeNode_.getValue().getInterval();
    }

    public int getIntervalDays() {
        return this.currentChangeNode_.getValue().getInterval().getDays();
    }

    public long getIntervalMillis() {
        return this.currentChangeNode_.getValue().getInterval().getTimeInMillis();
    }

    public long getLong() {
        return this.currentChangeNode_.getValue().getLong();
    }

    public short getShort() {
        return this.currentChangeNode_.getValue().getShort();
    }

    public String getString() {
        return this.currentChangeNode_.getValue().getString();
    }

    public OTime getTime() {
        return this.currentChangeNode_.getValue().getTime();
    }

    public int getTimeInt() {
        return this.currentChangeNode_.getValue().getTimeAsInt();
    }

    public OTimestamp getTimestamp() {
        return this.currentChangeNode_.getValue().getTimestamp();
    }

    public long getTimestampLong() {
        return this.currentChangeNode_.getValue().getTimestampAsLong();
    }

    public boolean inMap() {
        return this.currentChangeNode_.inMap();
    }

    public DocumentReader.EventType next() {
        throw new UnsupportedOperationException();
    }

    public ControlInfo getControlInfo() {
        throw new UnsupportedOperationException();
    }

    public Value getId() {
        return this.dbReader_.getId();
    }

    public boolean hasRootTS() {
        return this.dbReader_.hasRootTS();
    }

    public TimeAndUniq[] getRootTS() {
        if (this.doneSearchRootTS_) {
            return this.rootTS_;
        }
        while (!this.doneSearchRootTS_) {
            ChangeNodeImpl tmp = this.nextChangeDataNodeInternal();
            ChangeNodeImpl cachedNode = null;
            if (tmp != null) {
                cachedNode = new ChangeNodeImpl(tmp);
                this.nodeQueue_.add(cachedNode);
                this.lastNodeInQueue_ = cachedNode;
            }
            this.rootTS_ = this.dbReader_.getRootTS();
            if (this.rootTS_ != null) {
                this.doneSearchRootTS_ = true;
                break;
            }
            if (tmp == null) {
                LOG.warn("create/update/delete timestamp not found on root of doc with id " + (this.dbReader_.getId().getType() == Value.Type.STRING ? this.dbReader_.getId().getString() : BinaryString.toStringBinary((byte[])this.dbReader_.getId().getBinary().array())));
                this.doneSearchRootTS_ = true;
                this.rootTS_ = null;
                break;
            }
            if ((cachedNode.getFieldName() == null || cachedNode.getFieldName().equals("")) && !cachedNode.inArray()) continue;
            LOG.debug("Hit field " + cachedNode.getFieldName() + ", no RootTS found");
            this.doneSearchRootTS_ = true;
            this.rootTS_ = null;
            break;
        }
        return this.rootTS_;
    }

    ChangeNodeImpl peekLastNodeInQueue() {
        return this.lastNodeInQueue_;
    }

    private boolean isTSZero(TimeAndUniq[] tmp) {
        if (tmp == null) {
            return true;
        }
        boolean isZero = true;
        for (int i = 0; i < tmp.length; ++i) {
            if (tmp[i] == null || tmp[i].time() == 0L) continue;
            isZero = false;
        }
        return isZero;
    }
}

