/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.impl;

import com.mapr.db.cdc.impl.ChangeDataUtil;
import com.mapr.db.cdc.impl.ChangeNodeImpl;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.proto.Dbserver;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.cdc.ChangeDataRecord;
import org.ojai.store.cdc.ChangeDataRecordType;
import org.ojai.store.cdc.ChangeEvent;
import org.ojai.store.cdc.ChangeOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChangeDataRecordImpl
implements ChangeDataRecord {
    static final Logger LOG = LoggerFactory.getLogger(ChangeDataRecordImpl.class);
    protected ChangeOp opBaseType_ = null;
    protected long rowTime_ = 0L;
    protected long opBaseTime_ = 0L;
    protected Map<FieldPath, Integer> jsonPathMap_ = null;
    protected Map<Integer, String> idToCFNameMap_ = null;
    private boolean isJson_ = false;
    protected MapRResult result_ = null;
    private Value rowKey_ = null;
    protected ChangeNodeImpl recCachedNode_ = null;
    protected boolean initialCopy_ = false;

    public ChangeDataRecordImpl(Map<FieldPath, Integer> jsonPathMap, Map<Integer, String> idToCFNameMap, Dbserver.RawChangeData rData, ByteBuffer valueBuf) throws IllegalArgumentException {
        this.jsonPathMap_ = jsonPathMap;
        this.idToCFNameMap_ = idToCFNameMap;
        this.isJson_ = rData.getIsJson();
        this.initialCopy_ = rData.getInitialCopy();
        Dbserver.CompressedRow crow = rData.getCrow();
        this.result_ = ChangeDataUtil.genMapRResult(valueBuf, crow, this.isJson_);
        ByteBuffer rowKeyBuf = this.result_.getKey();
        if (rowKeyBuf == null) {
            throw new IllegalArgumentException("No row key found");
        }
        this.rowKey_ = ChangeDataRecordImpl.parseRowKey(this.isJson_, rowKeyBuf);
        if (this.result_.getIsDelete()) {
            this.opBaseType_ = ChangeOp.DELETE;
            this.opBaseTime_ = this.rowTime_ = this.result_.getDeleteTs();
            this.recCachedNode_ = new ChangeNodeImpl(ChangeEvent.NODE, ChangeOp.DELETE, this.result_.getDeleteTs(), this.result_.getDeleteTs(), null, -1, null, null, false, this.isJson_);
            LOG.debug("---found row delete: " + this.recCachedNode_);
            return;
        }
        this.opBaseTime_ = this.rowTime_ = this.result_.getRowTs();
        this.opBaseType_ = ChangeOp.MERGE;
    }

    public static void copyByteBufferMap(Map<Integer, ByteBuffer> inMap, Map<Integer, ByteBuffer> outMap) {
        outMap.clear();
        for (Map.Entry<Integer, ByteBuffer> entry : inMap.entrySet()) {
            ByteBuffer outBuf = entry.getValue().duplicate();
            outMap.put(entry.getKey(), outBuf);
        }
    }

    public boolean isJson() {
        return this.isJson_;
    }

    public static Value parseRowKey(boolean isJson, ByteBuffer rowKeyBuf) {
        KeyValue rKey = null;
        if (!isJson) {
            rKey = DBValueBuilderImpl.KeyValueBuilder.initFrom(rowKeyBuf);
            return rKey;
        }
        return IdCodec.decode((ByteBuffer)rowKeyBuf);
    }

    public Value getId() {
        return this.rowKey_;
    }

    public ChangeOp getOpType() {
        return this.opBaseType_;
    }

    public long getOpTimestamp() {
        return this.opBaseTime_;
    }

    public ChangeDataRecordType getType() {
        switch (this.opBaseType_) {
            case DELETE: {
                return ChangeDataRecordType.RECORD_DELETE;
            }
            case MERGE: {
                return ChangeDataRecordType.RECORD_UPDATE;
            }
            case SET: {
                return ChangeDataRecordType.RECORD_INSERT;
            }
            case DELETE_EXACT: {
                throw new IllegalArgumentException("No DELETE_EXACT at row level");
            }
            case NULL: {
                throw new IllegalArgumentException("cdc for row key only record is not supported yet.");
            }
        }
        throw new IllegalArgumentException("Unknow ChangeOp type " + this.opBaseType_);
    }

    public long getServerTimestamp() {
        return this.getOpTimestamp();
    }

    class ChangeNodeStack {
        ArrayList<ChangeNodeImpl> nodelist = new ArrayList();

        public void pushNode(ChangeNodeImpl cd) {
            this.nodelist.add(cd);
        }

        public ChangeNodeImpl popNode() {
            int lastIdx = this.nodelist.size() - 1;
            return this.nodelist.remove(lastIdx);
        }

        public ChangeNodeImpl peekNode() {
            int lastIdx = this.nodelist.size() - 1;
            return this.nodelist.get(lastIdx);
        }

        public String getFieldsInStack() {
            Object fields = "";
            if (this.nodelist.isEmpty()) {
                return fields;
            }
            String fn = null;
            int lastIdx = this.nodelist.size();
            for (int i = 0; i < lastIdx; ++i) {
                ChangeNodeImpl cnode = this.nodelist.get(i);
                if (cnode.inArray()) {
                    int arrayIdx = cnode.getArrayIndex();
                    fields = (String)fields + "[" + arrayIdx + "]";
                    continue;
                }
                fn = cnode.getFieldName();
                if (i == 0) {
                    if (fn == null || fn.equals("")) continue;
                    fields = (String)fields + fn;
                    continue;
                }
                fields = ((String)fields).equals("") ? (String)fields + fn : (String)fields + "." + fn;
            }
            return fields;
        }

        public int size() {
            return this.nodelist.size();
        }

        public String toString() {
            int size = this.nodelist.size();
            Object nodes = "";
            for (int i = 0; i < size; ++i) {
                nodes = (String)nodes + this.nodelist.get(i).toString() + "\n";
            }
            return nodes;
        }
    }

    class ChangeNodeIteratorEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public ChangeNodeIteratorEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }
    }
}

