/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.impl;

import com.mapr.db.cdc.impl.ChangeDataDBDocumentReader;
import com.mapr.db.cdc.impl.ChangeDataRecordImpl;
import com.mapr.db.cdc.impl.ChangeNodeImpl;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.util.ByteBufs;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.ojai.Value;
import org.ojai.store.cdc.ChangeDataReader;
import org.ojai.store.cdc.ChangeEvent;
import org.ojai.store.cdc.ChangeOp;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class ChangeDataReaderImpl
implements ChangeDataReader {
    ChangeDataRecordImpl cdrImpl_ = null;
    ChangeDataDBDocumentReader docReader_ = null;
    ChangeNodeImpl currentChangeNode_ = null;
    ChangeNodeImpl cachedNode_ = null;

    public ChangeDataReaderImpl(ChangeDataRecordImpl cdrImpl, ChangeDataDBDocumentReader docReader, ChangeNodeImpl cachedNode) throws IllegalArgumentException {
        if (cdrImpl == null) {
            throw new IllegalArgumentException("Missing ChangeDataRecord!");
        }
        this.cdrImpl_ = cdrImpl;
        this.docReader_ = docReader;
        this.cachedNode_ = cachedNode == null ? null : new ChangeNodeImpl(cachedNode);
    }

    public ChangeEvent next() {
        if (this.cachedNode_ != null) {
            this.currentChangeNode_ = this.cachedNode_;
            this.cachedNode_ = null;
            return this.currentChangeNode_ == null ? null : this.currentChangeNode_.getEvent();
        }
        if (this.docReader_ != null) {
            this.currentChangeNode_ = this.docReader_.nextChangeDataNode();
            return this.currentChangeNode_ == null ? null : this.currentChangeNode_.getEvent();
        }
        return null;
    }

    public ChangeNodeImpl getChangeNode() {
        return new ChangeNodeImpl(this.currentChangeNode_);
    }

    public ChangeOp getOp() {
        return this.currentChangeNode_.getOp();
    }

    public String getFieldName() {
        return this.currentChangeNode_.getFieldName();
    }

    public ByteBuffer getFieldNameBytes() {
        return this.currentChangeNode_.getFieldNameBytes();
    }

    public boolean inMap() {
        return this.currentChangeNode_.inMap();
    }

    public int getArrayIndex() {
        return this.currentChangeNode_.getArrayIndex();
    }

    public Value.Type getType() {
        Value val = this.currentChangeNode_.getValue();
        if (val == null) {
            return null;
        }
        return val.getType();
    }

    public Value getValue() {
        return this.currentChangeNode_.getValue();
    }

    public long getOpTimestamp() {
        return this.currentChangeNode_.getOpTimestamp();
    }

    public boolean hasRootTS() {
        return this.docReader_.hasRootTS();
    }

    public TimeAndUniq[] getRootTS() {
        return this.docReader_.getRootTS();
    }

    ChangeNodeImpl peekLastNodeInQueue() {
        return this.docReader_.peekLastNodeInQueue();
    }

    public boolean inArray() {
        return this.currentChangeNode_.inArray();
    }

    public boolean hasNext() {
        if (this.cachedNode_ != null) {
            return true;
        }
        if (this.docReader_ != null) {
            this.cachedNode_ = this.docReader_.nextChangeDataNode();
            return this.cachedNode_ != null;
        }
        return false;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public byte getByte() {
        return this.getValue().getByte();
    }

    public short getShort() {
        return this.getValue().getShort();
    }

    public int getInt() {
        return this.getValue().getInt();
    }

    public long getLong() {
        return this.getValue().getLong();
    }

    public float getFloat() {
        return this.getValue().getFloat();
    }

    public double getDouble() {
        return this.getValue().getDouble();
    }

    public BigDecimal getDecimal() {
        return this.getValue().getDecimal();
    }

    public int getDecimalPrecision() {
        return this.getValue().getDecimal().precision();
    }

    public int getDecimalScale() {
        return this.getValue().getDecimal().scale();
    }

    public int getDecimalValueAsInt() {
        return this.getValue().getDecimal().intValue();
    }

    public long getDecimalValueAsLong() {
        return this.getValue().getDecimal().longValue();
    }

    public ByteBuffer getDecimalValueAsBytes() {
        return ByteBufs.decimalValueToBytes((BigDecimal)this.getDecimal());
    }

    public boolean getBoolean() {
        return this.getValue().getBoolean();
    }

    public String getString() {
        return this.getValue().getString();
    }

    public long getTimestampLong() {
        return this.getValue().getTimestampAsLong();
    }

    public OTimestamp getTimestamp() {
        return this.getValue().getTimestamp();
    }

    public int getDateInt() {
        return this.getValue().getDateAsInt();
    }

    public ODate getDate() {
        return this.getValue().getDate();
    }

    public int getTimeInt() {
        return this.getValue().getTimeAsInt();
    }

    public OTime getTime() {
        return this.getValue().getTime();
    }

    public OInterval getInterval() {
        return this.getValue().getInterval();
    }

    public long getIntervalMillis() {
        return this.getValue().getLong();
    }

    public ByteBuffer getBinary() {
        return this.getValue().getBinary();
    }

    public long getServerTimestamp() {
        return this.getOpTimestamp();
    }
}

